/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Rational;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.internal.audio.AudioSettings;
import androidx.camera.video.internal.config.AudioConfigUtil;
import androidx.camera.video.internal.config.CaptureEncodeRates;
import androidx.core.util.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AudioSettingsAudioProfileResolver
implements Supplier<AudioSettings> {
    private static final String TAG = "AudioSrcAdPrflRslvr";
    private final AudioSpec mAudioSpec;
    private final EncoderProfilesProxy.AudioProfileProxy mAudioProfile;
    private final @Nullable Rational mCaptureToEncodeRatio;

    public AudioSettingsAudioProfileResolver(@NonNull AudioSpec audioSpec, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EncoderProfilesProxy.AudioProfileProxy audioProfile, @Nullable Rational captureToEncodeRatio) {
        this.mAudioSpec = audioSpec;
        this.mAudioProfile = audioProfile;
        this.mCaptureToEncodeRatio = captureToEncodeRatio;
    }

    public @NonNull AudioSettings get() {
        int resolvedChannelCount;
        int resolvedAudioSource = AudioConfigUtil.resolveAudioSource(this.mAudioSpec);
        int resolvedSourceFormat = AudioConfigUtil.resolveAudioSourceFormat(this.mAudioSpec);
        int audioSpecChannelCount = this.mAudioSpec.getChannelCount();
        int audioProfileChannelCount = this.mAudioProfile.getChannels();
        if (audioSpecChannelCount == -1) {
            resolvedChannelCount = audioProfileChannelCount;
            Logger.d((String)TAG, (String)("Resolved AUDIO channel count from AudioProfile: " + resolvedChannelCount));
        } else {
            resolvedChannelCount = audioSpecChannelCount;
            Logger.d((String)TAG, (String)("Media spec AUDIO channel count overrides AudioProfile [AudioProfile channel count: " + audioProfileChannelCount + ", Resolved Channel Count: " + resolvedChannelCount + "]"));
        }
        Range<Integer> audioSpecSampleRate = this.mAudioSpec.getSampleRate();
        int audioProfileSampleRate = this.mAudioProfile.getSampleRate();
        CaptureEncodeRates resolvedSampleRates = AudioConfigUtil.resolveSampleRates(audioSpecSampleRate, audioProfileSampleRate, resolvedChannelCount, resolvedSourceFormat, this.mCaptureToEncodeRatio);
        Logger.d((String)TAG, (String)("Using resolved AUDIO sample rate or nearest supported from AudioProfile: Capture sample rate: " + resolvedSampleRates.getCaptureRate() + "Hz. Encode sample rate: " + resolvedSampleRates.getEncodeRate() + "Hz. [AudioProfile sample rate: " + audioProfileSampleRate + "Hz]"));
        return AudioSettings.builder().setAudioSource(resolvedAudioSource).setAudioFormat(resolvedSourceFormat).setChannelCount(resolvedChannelCount).setCaptureSampleRate(resolvedSampleRates.getCaptureRate()).setEncodeSampleRate(resolvedSampleRates.getEncodeRate()).build();
    }
}

