/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import android.util.Rational;
import androidx.camera.core.Logger;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.internal.audio.AudioSettings;
import androidx.camera.video.internal.config.AudioConfigUtil;
import androidx.camera.video.internal.config.CaptureEncodeRates;
import androidx.core.util.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AudioSettingsDefaultResolver
implements Supplier<AudioSettings> {
    private static final String TAG = "DefAudioResolver";
    private final AudioSpec mAudioSpec;
    private final @Nullable Rational mCaptureToEncodeRatio;

    public AudioSettingsDefaultResolver(@NonNull AudioSpec audioSpec, @Nullable Rational captureToEncodeRatio) {
        this.mAudioSpec = audioSpec;
        this.mCaptureToEncodeRatio = captureToEncodeRatio;
    }

    public @NonNull AudioSettings get() {
        int resolvedChannelCount;
        int resolvedAudioSource = AudioConfigUtil.resolveAudioSource(this.mAudioSpec);
        int resolvedSourceFormat = AudioConfigUtil.resolveAudioSourceFormat(this.mAudioSpec);
        int audioSpecChannelCount = this.mAudioSpec.getChannelCount();
        if (audioSpecChannelCount == -1) {
            resolvedChannelCount = 1;
            Logger.d((String)TAG, (String)("Using fallback AUDIO channel count: " + resolvedChannelCount));
        } else {
            resolvedChannelCount = audioSpecChannelCount;
            Logger.d((String)TAG, (String)("Using supplied AUDIO channel count: " + audioSpecChannelCount));
        }
        Range<Integer> audioSpecSampleRateRange = this.mAudioSpec.getSampleRate();
        int targetSampleRate = AudioSpec.SAMPLE_RATE_RANGE_AUTO.equals(audioSpecSampleRateRange) ? 44100 : (Integer)audioSpecSampleRateRange.getUpper();
        CaptureEncodeRates resolvedSampleRates = AudioConfigUtil.resolveSampleRates(audioSpecSampleRateRange, targetSampleRate, resolvedChannelCount, resolvedAudioSource, this.mCaptureToEncodeRatio);
        Logger.d((String)TAG, (String)("Using AUDIO sample rate resolved from AudioSpec: Capture sample rate: " + resolvedSampleRates.getCaptureRate() + "Hz. Encode sample rate: " + resolvedSampleRates.getEncodeRate() + "Hz."));
        return AudioSettings.builder().setAudioSource(resolvedAudioSource).setAudioFormat(resolvedSourceFormat).setChannelCount(resolvedChannelCount).setCaptureSampleRate(resolvedSampleRates.getCaptureRate()).setEncodeSampleRate(resolvedSampleRates.getEncodeRate()).build();
    }
}

