/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Rational;
import androidx.camera.core.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u001a\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"TAG", "", "toEncodeRate", "", "captureRate", "captureToEncodeRatio", "Landroid/util/Rational;", "toCaptureRate", "encodeRate", "isInvalidCaptureToEncodeRatio", "", "ratio", "camera-video_release"})
public final class CaptureEncodeRatesKt {
    @NotNull
    private static final String TAG = "CaptureEncodeRates";

    public static final int toEncodeRate(int captureRate, @Nullable Rational captureToEncodeRatio) {
        if (captureToEncodeRatio == null) {
            return captureRate;
        }
        if (CaptureEncodeRatesKt.isInvalidCaptureToEncodeRatio(captureToEncodeRatio)) {
            Logger.w((String)TAG, (String)("Invalid capture-to-encode ratio: " + captureToEncodeRatio));
            return captureRate;
        }
        return MathKt.roundToInt((float)((float)captureRate / captureToEncodeRatio.floatValue()));
    }

    public static final int toCaptureRate(int encodeRate, @Nullable Rational captureToEncodeRatio) {
        if (captureToEncodeRatio == null) {
            return encodeRate;
        }
        if (CaptureEncodeRatesKt.isInvalidCaptureToEncodeRatio(captureToEncodeRatio)) {
            Logger.w((String)TAG, (String)("Invalid capture-to-encode ratio: " + captureToEncodeRatio));
            return encodeRate;
        }
        return MathKt.roundToInt((float)((float)encodeRate * captureToEncodeRatio.floatValue()));
    }

    private static final boolean isInvalidCaptureToEncodeRatio(Rational ratio) {
        return Intrinsics.areEqual((Object)ratio, (Object)Rational.NaN) || Intrinsics.areEqual((Object)ratio, (Object)Rational.ZERO) || Intrinsics.areEqual((Object)ratio, (Object)Rational.NEGATIVE_INFINITY) || Intrinsics.areEqual((Object)ratio, (Object)Rational.POSITIVE_INFINITY);
    }
}

