/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaFormat;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.encoder.AutoValue_AudioEncoderConfig;
import androidx.camera.video.internal.encoder.EncoderConfig;
import com.google.auto.value.AutoValue;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

@AutoValue
public abstract class AudioEncoderConfig
implements EncoderConfig {
    AudioEncoderConfig() {
    }

    public static @NonNull Builder builder() {
        return new AutoValue_AudioEncoderConfig.Builder().setProfile(-1);
    }

    @Override
    public abstract @NonNull String getMimeType();

    @Override
    public abstract int getProfile();

    @Override
    public abstract @NonNull Timebase getInputTimebase();

    public abstract int getBitrate();

    public abstract int getCaptureSampleRate();

    public abstract int getEncodeSampleRate();

    public abstract int getChannelCount();

    @Override
    public @NonNull MediaFormat toMediaFormat() {
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)this.getMimeType(), (int)this.getEncodeSampleRate(), (int)this.getChannelCount());
        mediaFormat.setInteger("bitrate", this.getBitrate());
        if (this.getProfile() != -1) {
            if (this.getMimeType().equals("audio/mp4a-latm")) {
                mediaFormat.setInteger("aac-profile", this.getProfile());
            } else {
                mediaFormat.setInteger("profile", this.getProfile());
            }
        }
        return mediaFormat;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract @NonNull Builder setMimeType(@NonNull String var1);

        public abstract @NonNull Builder setProfile(int var1);

        public abstract @NonNull Builder setInputTimebase(@NonNull Timebase var1);

        public abstract @NonNull Builder setBitrate(int var1);

        public abstract @NonNull Builder setCaptureSampleRate(int var1);

        public abstract @NonNull Builder setEncodeSampleRate(int var1);

        public abstract @NonNull Builder setChannelCount(int var1);

        abstract @NonNull AudioEncoderConfig autoBuild();

        public @NonNull AudioEncoderConfig build() {
            AudioEncoderConfig config = this.autoBuild();
            if (Objects.equals(config.getMimeType(), "audio/mp4a-latm") && config.getProfile() == -1) {
                throw new IllegalArgumentException("Encoder mime set to AAC, but no AAC profile was provided.");
            }
            return config;
        }
    }
}

