/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;
import org.jspecify.annotations.NonNull;

final class AutoValue_AudioEncoderConfig
extends AudioEncoderConfig {
    private final @NonNull String mimeType;
    private final int profile;
    private final @NonNull Timebase inputTimebase;
    private final int bitrate;
    private final int captureSampleRate;
    private final int encodeSampleRate;
    private final int channelCount;

    private AutoValue_AudioEncoderConfig(@NonNull String mimeType, int profile, @NonNull Timebase inputTimebase, int bitrate, int captureSampleRate, int encodeSampleRate, int channelCount) {
        this.mimeType = mimeType;
        this.profile = profile;
        this.inputTimebase = inputTimebase;
        this.bitrate = bitrate;
        this.captureSampleRate = captureSampleRate;
        this.encodeSampleRate = encodeSampleRate;
        this.channelCount = channelCount;
    }

    @Override
    public @NonNull String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getProfile() {
        return this.profile;
    }

    @Override
    public @NonNull Timebase getInputTimebase() {
        return this.inputTimebase;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    @Override
    public int getCaptureSampleRate() {
        return this.captureSampleRate;
    }

    @Override
    public int getEncodeSampleRate() {
        return this.encodeSampleRate;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    public String toString() {
        return "AudioEncoderConfig{mimeType=" + this.mimeType + ", profile=" + this.profile + ", inputTimebase=" + this.inputTimebase + ", bitrate=" + this.bitrate + ", captureSampleRate=" + this.captureSampleRate + ", encodeSampleRate=" + this.encodeSampleRate + ", channelCount=" + this.channelCount + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AudioEncoderConfig) {
            AudioEncoderConfig that = (AudioEncoderConfig)o;
            return this.mimeType.equals(that.getMimeType()) && this.profile == that.getProfile() && this.inputTimebase.equals((Object)that.getInputTimebase()) && this.bitrate == that.getBitrate() && this.captureSampleRate == that.getCaptureSampleRate() && this.encodeSampleRate == that.getEncodeSampleRate() && this.channelCount == that.getChannelCount();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mimeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.profile;
        h$ *= 1000003;
        h$ ^= this.inputTimebase.hashCode();
        h$ *= 1000003;
        h$ ^= this.bitrate;
        h$ *= 1000003;
        h$ ^= this.captureSampleRate;
        h$ *= 1000003;
        h$ ^= this.encodeSampleRate;
        h$ *= 1000003;
        return h$ ^= this.channelCount;
    }

    static final class Builder
    extends AudioEncoderConfig.Builder {
        private @NonNull String mimeType;
        private Integer profile;
        private @NonNull Timebase inputTimebase;
        private Integer bitrate;
        private Integer captureSampleRate;
        private Integer encodeSampleRate;
        private Integer channelCount;

        Builder() {
        }

        @Override
        public AudioEncoderConfig.Builder setMimeType(@NonNull String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("Null mimeType");
            }
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setProfile(int profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setInputTimebase(@NonNull Timebase inputTimebase) {
            if (inputTimebase == null) {
                throw new NullPointerException("Null inputTimebase");
            }
            this.inputTimebase = inputTimebase;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setCaptureSampleRate(int captureSampleRate) {
            this.captureSampleRate = captureSampleRate;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setEncodeSampleRate(int encodeSampleRate) {
            this.encodeSampleRate = encodeSampleRate;
            return this;
        }

        @Override
        public AudioEncoderConfig.Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        @Override
        AudioEncoderConfig autoBuild() {
            String missing = "";
            if (this.mimeType == null) {
                missing = missing + " mimeType";
            }
            if (this.profile == null) {
                missing = missing + " profile";
            }
            if (this.inputTimebase == null) {
                missing = missing + " inputTimebase";
            }
            if (this.bitrate == null) {
                missing = missing + " bitrate";
            }
            if (this.captureSampleRate == null) {
                missing = missing + " captureSampleRate";
            }
            if (this.encodeSampleRate == null) {
                missing = missing + " encodeSampleRate";
            }
            if (this.channelCount == null) {
                missing = missing + " channelCount";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AudioEncoderConfig(this.mimeType, this.profile, this.inputTimebase, this.bitrate, this.captureSampleRate, this.encodeSampleRate, this.channelCount);
        }
    }
}

