/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.util.Size;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderDataSpace;
import org.jspecify.annotations.NonNull;

final class AutoValue_VideoEncoderConfig
extends VideoEncoderConfig {
    private final @NonNull String mimeType;
    private final int profile;
    private final @NonNull Timebase inputTimebase;
    private final @NonNull Size resolution;
    private final int colorFormat;
    private final @NonNull VideoEncoderDataSpace dataSpace;
    private final int captureFrameRate;
    private final int encodeFrameRate;
    private final int IFrameInterval;
    private final int bitrate;

    private AutoValue_VideoEncoderConfig(@NonNull String mimeType, int profile, @NonNull Timebase inputTimebase, @NonNull Size resolution, int colorFormat, @NonNull VideoEncoderDataSpace dataSpace, int captureFrameRate, int encodeFrameRate, int IFrameInterval, int bitrate) {
        this.mimeType = mimeType;
        this.profile = profile;
        this.inputTimebase = inputTimebase;
        this.resolution = resolution;
        this.colorFormat = colorFormat;
        this.dataSpace = dataSpace;
        this.captureFrameRate = captureFrameRate;
        this.encodeFrameRate = encodeFrameRate;
        this.IFrameInterval = IFrameInterval;
        this.bitrate = bitrate;
    }

    @Override
    public @NonNull String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getProfile() {
        return this.profile;
    }

    @Override
    public @NonNull Timebase getInputTimebase() {
        return this.inputTimebase;
    }

    @Override
    public @NonNull Size getResolution() {
        return this.resolution;
    }

    @Override
    public int getColorFormat() {
        return this.colorFormat;
    }

    @Override
    public @NonNull VideoEncoderDataSpace getDataSpace() {
        return this.dataSpace;
    }

    @Override
    public int getCaptureFrameRate() {
        return this.captureFrameRate;
    }

    @Override
    public int getEncodeFrameRate() {
        return this.encodeFrameRate;
    }

    @Override
    public int getIFrameInterval() {
        return this.IFrameInterval;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    public String toString() {
        return "VideoEncoderConfig{mimeType=" + this.mimeType + ", profile=" + this.profile + ", inputTimebase=" + this.inputTimebase + ", resolution=" + this.resolution + ", colorFormat=" + this.colorFormat + ", dataSpace=" + this.dataSpace + ", captureFrameRate=" + this.captureFrameRate + ", encodeFrameRate=" + this.encodeFrameRate + ", IFrameInterval=" + this.IFrameInterval + ", bitrate=" + this.bitrate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VideoEncoderConfig) {
            VideoEncoderConfig that = (VideoEncoderConfig)o;
            return this.mimeType.equals(that.getMimeType()) && this.profile == that.getProfile() && this.inputTimebase.equals((Object)that.getInputTimebase()) && this.resolution.equals((Object)that.getResolution()) && this.colorFormat == that.getColorFormat() && this.dataSpace.equals(that.getDataSpace()) && this.captureFrameRate == that.getCaptureFrameRate() && this.encodeFrameRate == that.getEncodeFrameRate() && this.IFrameInterval == that.getIFrameInterval() && this.bitrate == that.getBitrate();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mimeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.profile;
        h$ *= 1000003;
        h$ ^= this.inputTimebase.hashCode();
        h$ *= 1000003;
        h$ ^= this.resolution.hashCode();
        h$ *= 1000003;
        h$ ^= this.colorFormat;
        h$ *= 1000003;
        h$ ^= this.dataSpace.hashCode();
        h$ *= 1000003;
        h$ ^= this.captureFrameRate;
        h$ *= 1000003;
        h$ ^= this.encodeFrameRate;
        h$ *= 1000003;
        h$ ^= this.IFrameInterval;
        h$ *= 1000003;
        return h$ ^= this.bitrate;
    }

    @Override
    public VideoEncoderConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends VideoEncoderConfig.Builder {
        private @NonNull String mimeType;
        private Integer profile;
        private @NonNull Timebase inputTimebase;
        private @NonNull Size resolution;
        private Integer colorFormat;
        private @NonNull VideoEncoderDataSpace dataSpace;
        private Integer captureFrameRate;
        private Integer encodeFrameRate;
        private Integer IFrameInterval;
        private Integer bitrate;

        Builder() {
        }

        private Builder(VideoEncoderConfig source) {
            this.mimeType = source.getMimeType();
            this.profile = source.getProfile();
            this.inputTimebase = source.getInputTimebase();
            this.resolution = source.getResolution();
            this.colorFormat = source.getColorFormat();
            this.dataSpace = source.getDataSpace();
            this.captureFrameRate = source.getCaptureFrameRate();
            this.encodeFrameRate = source.getEncodeFrameRate();
            this.IFrameInterval = source.getIFrameInterval();
            this.bitrate = source.getBitrate();
        }

        @Override
        public VideoEncoderConfig.Builder setMimeType(@NonNull String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("Null mimeType");
            }
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setProfile(int profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setInputTimebase(@NonNull Timebase inputTimebase) {
            if (inputTimebase == null) {
                throw new NullPointerException("Null inputTimebase");
            }
            this.inputTimebase = inputTimebase;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setResolution(@NonNull Size resolution) {
            if (resolution == null) {
                throw new NullPointerException("Null resolution");
            }
            this.resolution = resolution;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setColorFormat(int colorFormat) {
            this.colorFormat = colorFormat;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setDataSpace(@NonNull VideoEncoderDataSpace dataSpace) {
            if (dataSpace == null) {
                throw new NullPointerException("Null dataSpace");
            }
            this.dataSpace = dataSpace;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setCaptureFrameRate(int captureFrameRate) {
            this.captureFrameRate = captureFrameRate;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setEncodeFrameRate(int encodeFrameRate) {
            this.encodeFrameRate = encodeFrameRate;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setIFrameInterval(int IFrameInterval) {
            this.IFrameInterval = IFrameInterval;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        @Override
        public VideoEncoderConfig build() {
            String missing = "";
            if (this.mimeType == null) {
                missing = missing + " mimeType";
            }
            if (this.profile == null) {
                missing = missing + " profile";
            }
            if (this.inputTimebase == null) {
                missing = missing + " inputTimebase";
            }
            if (this.resolution == null) {
                missing = missing + " resolution";
            }
            if (this.colorFormat == null) {
                missing = missing + " colorFormat";
            }
            if (this.dataSpace == null) {
                missing = missing + " dataSpace";
            }
            if (this.captureFrameRate == null) {
                missing = missing + " captureFrameRate";
            }
            if (this.encodeFrameRate == null) {
                missing = missing + " encodeFrameRate";
            }
            if (this.IFrameInterval == null) {
                missing = missing + " IFrameInterval";
            }
            if (this.bitrate == null) {
                missing = missing + " bitrate";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_VideoEncoderConfig(this.mimeType, this.profile, this.inputTimebase, this.resolution, this.colorFormat, this.dataSpace, this.captureFrameRate, this.encodeFrameRate, this.IFrameInterval, this.bitrate);
        }
    }
}

