/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.util.Range;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.core.util.Preconditions;
import org.jspecify.annotations.NonNull;

public class SwappedVideoEncoderInfo
implements VideoEncoderInfo {
    private final VideoEncoderInfo mVideoEncoderInfo;

    public SwappedVideoEncoderInfo(@NonNull VideoEncoderInfo videoEncoderInfo) {
        Preconditions.checkArgument((boolean)videoEncoderInfo.canSwapWidthHeight());
        this.mVideoEncoderInfo = videoEncoderInfo;
    }

    @Override
    public @NonNull String getName() {
        return this.mVideoEncoderInfo.getName();
    }

    @Override
    public boolean canSwapWidthHeight() {
        return this.mVideoEncoderInfo.canSwapWidthHeight();
    }

    @Override
    public boolean isSizeSupported(int width, int height) {
        return this.mVideoEncoderInfo.isSizeSupported(height, width);
    }

    @Override
    public @NonNull Range<Integer> getSupportedWidths() {
        return this.mVideoEncoderInfo.getSupportedHeights();
    }

    @Override
    public @NonNull Range<Integer> getSupportedHeights() {
        return this.mVideoEncoderInfo.getSupportedWidths();
    }

    @Override
    public @NonNull Range<Integer> getSupportedWidthsFor(int height) {
        return this.mVideoEncoderInfo.getSupportedHeightsFor(height);
    }

    @Override
    public @NonNull Range<Integer> getSupportedHeightsFor(int width) {
        return this.mVideoEncoderInfo.getSupportedWidthsFor(width);
    }

    @Override
    public int getWidthAlignment() {
        return this.mVideoEncoderInfo.getHeightAlignment();
    }

    @Override
    public int getHeightAlignment() {
        return this.mVideoEncoderInfo.getWidthAlignment();
    }

    @Override
    public @NonNull Range<Integer> getSupportedBitrateRange() {
        return this.mVideoEncoderInfo.getSupportedBitrateRange();
    }
}

