/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaFormat;
import android.util.Size;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.encoder.AutoValue_VideoEncoderConfig;
import androidx.camera.video.internal.encoder.EncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderDataSpace;
import com.google.auto.value.AutoValue;
import org.jspecify.annotations.NonNull;

@AutoValue
public abstract class VideoEncoderConfig
implements EncoderConfig {
    private static final int VIDEO_INTRA_FRAME_INTERVAL_DEFAULT = 1;
    private static final int VIDEO_COLOR_FORMAT_DEFAULT = 2130708361;

    VideoEncoderConfig() {
    }

    public static @NonNull Builder builder() {
        return new AutoValue_VideoEncoderConfig.Builder().setProfile(-1).setIFrameInterval(1).setColorFormat(2130708361).setDataSpace(VideoEncoderDataSpace.ENCODER_DATA_SPACE_UNSPECIFIED);
    }

    public abstract @NonNull Builder toBuilder();

    @Override
    public abstract @NonNull String getMimeType();

    @Override
    public abstract int getProfile();

    @Override
    public abstract @NonNull Timebase getInputTimebase();

    public abstract @NonNull Size getResolution();

    public abstract int getColorFormat();

    public abstract @NonNull VideoEncoderDataSpace getDataSpace();

    public abstract int getCaptureFrameRate();

    public abstract int getEncodeFrameRate();

    public abstract int getIFrameInterval();

    public abstract int getBitrate();

    @Override
    public @NonNull MediaFormat toMediaFormat() {
        VideoEncoderDataSpace dataSpace;
        Size size = this.getResolution();
        MediaFormat format = MediaFormat.createVideoFormat((String)this.getMimeType(), (int)size.getWidth(), (int)size.getHeight());
        format.setInteger("color-format", this.getColorFormat());
        format.setInteger("bitrate", this.getBitrate());
        format.setInteger("frame-rate", this.getEncodeFrameRate());
        if (this.getEncodeFrameRate() != this.getCaptureFrameRate()) {
            format.setInteger("capture-rate", this.getCaptureFrameRate());
            format.setInteger("operating-rate", this.getCaptureFrameRate());
            format.setInteger("priority", 0);
        }
        format.setInteger("i-frame-interval", this.getIFrameInterval());
        if (this.getProfile() != -1) {
            format.setInteger("profile", this.getProfile());
        }
        if ((dataSpace = this.getDataSpace()).getStandard() != 0) {
            format.setInteger("color-standard", dataSpace.getStandard());
        }
        if (dataSpace.getTransfer() != 0) {
            format.setInteger("color-transfer", dataSpace.getTransfer());
        }
        if (dataSpace.getRange() != 0) {
            format.setInteger("color-range", dataSpace.getRange());
        }
        return format;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract @NonNull Builder setMimeType(@NonNull String var1);

        public abstract @NonNull Builder setProfile(int var1);

        public abstract @NonNull Builder setInputTimebase(@NonNull Timebase var1);

        public abstract @NonNull Builder setResolution(@NonNull Size var1);

        public abstract @NonNull Builder setColorFormat(int var1);

        public abstract @NonNull Builder setDataSpace(@NonNull VideoEncoderDataSpace var1);

        public abstract @NonNull Builder setCaptureFrameRate(int var1);

        public abstract @NonNull Builder setEncodeFrameRate(int var1);

        public abstract @NonNull Builder setIFrameInterval(int var1);

        public abstract @NonNull Builder setBitrate(int var1);

        public abstract @NonNull VideoEncoderConfig build();
    }
}

