/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.utils;

import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import androidx.camera.core.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/camera/video/internal/utils/StorageUtil;", "", "<init>", "()V", "TAG", "", "getAvailableBytes", "", "file", "Ljava/io/File;", "path", "getAvailableBytesForMediaStoreUri", "uri", "Landroid/net/Uri;", "formatSize", "bytes", "isStorageFullException", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "camera-video_release"})
@SourceDebugExtension(value={"SMAP\nStorageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageUtil.kt\nandroidx/camera/video/internal/utils/StorageUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class StorageUtil {
    @NotNull
    public static final StorageUtil INSTANCE = new StorageUtil();
    @NotNull
    private static final String TAG = "StorageUtil";

    private StorageUtil() {
    }

    @JvmStatic
    public static final long getAvailableBytes(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StorageUtil.getAvailableBytes(string);
    }

    @JvmStatic
    public static final long getAvailableBytes(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new StatFs(path).getAvailableBytes();
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    public static final long getAvailableBytesForMediaStoreUri(@NotNull Uri uri) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
                    $i$a$-check-StorageUtil$getAvailableBytesForMediaStoreUri$1 = false;
                    var2_2 = "Not a content uri: " + uri;
                    throw new IllegalStateException(var2_2.toString());
                }
                var1_3 = (String)uri.getPathSegments().get(0);
                if (var1_3 == null) break block7;
                switch (var1_3.hashCode()) {
                    case -1820761141: {
                        if (!var1_3.equals("external")) {
                            ** break;
                        }
                        ** GOTO lbl19
                    }
                    case 570410685: {
                        if (var1_3.equals("internal")) break;
                        ** break;
                    }
                    case -1921573490: {
                        if (!var1_3.equals("external_primary")) ** break;
lbl19:
                        // 2 sources

                        v0 = Environment.getExternalStorageDirectory();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getExternalStorageDirectory(...)");
                        v1 = StorageUtil.getAvailableBytes(v0);
                        break block8;
                    }
                }
                v2 = Environment.getDataDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDataDirectory(...)");
                v1 = StorageUtil.getAvailableBytes(v2);
                break block8;
            }
            Logger.w((String)"StorageUtil", (String)("Unknown MediaStore URI: " + uri));
            v1 = 0x7FFFFFFFFFFFFFFFL;
        }
        return v1;
    }

    @JvmStatic
    @NotNull
    public static final String formatSize(long bytes) {
        double size;
        if (!(bytes >= 0L)) {
            boolean $i$a$-require-StorageUtil$formatSize$22 = false;
            String $i$a$-require-StorageUtil$formatSize$22 = "Bytes cannot be negative";
            throw new IllegalArgumentException($i$a$-require-StorageUtil$formatSize$22.toString());
        }
        String[] $i$a$-require-StorageUtil$formatSize$22 = new String[]{"B", "KB", "MB", "GB", "TB"};
        String[] units = $i$a$-require-StorageUtil$formatSize$22;
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        int unitIndex = 0;
        for (size = (double)bytes; size >= 1024.0 && unitIndex < units.length - 1; size /= 1024.0, ++unitIndex) {
        }
        if (unitIndex == 0) {
            return decimalFormat.format(size) + ' ' + units[unitIndex];
        }
        StringBuilder result = new StringBuilder();
        double remainingSize = bytes;
        for (int i = unitIndex; -1 < i; --i) {
            double unitSize = Math.pow(1024.0, i);
            double unitValue = Math.floor(remainingSize / unitSize);
            if (!(unitValue > 0.0)) continue;
            result.append(decimalFormat.format(unitValue)).append(" ").append(units[i]).append(" ");
            remainingSize -= unitValue * unitSize;
        }
        return ((Object)StringsKt.trim((CharSequence)result)).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isStorageFullException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!(e instanceof FileNotFoundException)) return false;
        String string = e.getMessage();
        if (string == null) return false;
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"No space left on device", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

