/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import android.util.Pair;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.NegativeLatLongSavesIncorrectlyQuirk;
import org.jspecify.annotations.NonNull;

public final class CorrectNegativeLatLongForMediaMuxer {
    private CorrectNegativeLatLongForMediaMuxer() {
    }

    public static @NonNull Pair<Double, Double> adjustGeoLocation(double latitude, double longitude) {
        if (DeviceQuirks.get(NegativeLatLongSavesIncorrectlyQuirk.class) != null) {
            latitude = CorrectNegativeLatLongForMediaMuxer.adjustInternal(latitude);
            longitude = CorrectNegativeLatLongForMediaMuxer.adjustInternal(longitude);
        }
        return Pair.create((Object)latitude, (Object)longitude);
    }

    private static double adjustInternal(double value) {
        return value >= 0.0 ? value : (value * 10000.0 - 1.0) / 10000.0;
    }
}

