/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import android.util.Size;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 :2\u00020\u0001:\u0001:B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0002J,\u0010$\u001a\u00020\u00172\b\b\u0002\u0010%\u001a\u00020\u00162\b\b\u0002\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002Jf\u0010*\u001a\u00020\u001f2\b\b\u0002\u0010+\u001a\u00020\u00162\b\b\u0002\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00162\b\b\u0002\u0010.\u001a\u00020\u00162\b\b\u0002\u0010/\u001a\u00020\u00162\b\b\u0002\u00100\u001a\u00020\u00162\b\b\u0002\u00101\u001a\u00020\u00162\b\b\u0002\u00102\u001a\u00020\u0016H\u0002JD\u00103\u001a\u00020)2\b\b\u0002\u0010+\u001a\u00020\u00162\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u00104\u001a\u00020\u00162\b\b\u0002\u00105\u001a\u00020\u00162\b\b\u0002\u00106\u001a\u00020\u00162\b\b\u0002\u0010/\u001a\u00020\u0016H\u0002J\f\u00107\u001a\u00020\u0016*\u00020\u0006H\u0002J\u001c\u00108\u001a\u0004\u0018\u000109*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010\u000b\u001a.\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\u0005\u00a2\u0006\u0002\b\u000f0\f\u00a2\u0006\u0002\b\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Landroidx/camera/video/internal/workaround/DefaultEncoderProfilesProvider;", "Landroidx/camera/core/impl/EncoderProfilesProvider;", "cameraInfo", "Landroidx/camera/core/impl/CameraInfoInternal;", "targetQualities", "", "Landroidx/camera/video/Quality;", "videoEncoderInfoFinder", "Landroidx/camera/video/internal/encoder/VideoEncoderInfo$Finder;", "<init>", "(Landroidx/camera/core/impl/CameraInfoInternal;Ljava/util/List;Landroidx/camera/video/internal/encoder/VideoEncoderInfo$Finder;)V", "supportedSizes", "", "Landroid/util/Size;", "kotlin.jvm.PlatformType", "Lorg/jspecify/annotations/NonNull;", "getSupportedSizes", "()Ljava/util/List;", "supportedSizes$delegate", "Lkotlin/Lazy;", "encoderProfilesMap", "", "", "Landroidx/camera/core/impl/EncoderProfilesProxy;", "hasProfile", "", "quality", "getAll", "getProfileInternal", "generateEncoderProfiles", "generateVideoProfiles", "Landroidx/camera/core/impl/EncoderProfilesProxy$VideoProfileProxy;", "resolveVideoProfile", "width", "height", "bitrate", "createDefaultEncoderProfiles", "defaultDurationSeconds", "recommendedFileFormat", "videoProfile", "audioProfile", "Landroidx/camera/core/impl/EncoderProfilesProxy$AudioProfileProxy;", "createDefaultVideoProfile", "codec", "mimeType", "", "frameRate", "profile", "bitDepth", "chromaSubsampling", "hdrFormat", "createDefaultAudioProfile", "bitRate", "sampleRate", "channels", "getTypicalBitrate", "find", "Landroidx/camera/video/Quality$ConstantQuality;", "Companion", "camera-video_release"})
@SourceDebugExtension(value={"SMAP\nDefaultEncoderProfilesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultEncoderProfilesProvider.kt\nandroidx/camera/video/internal/workaround/DefaultEncoderProfilesProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1#2:239\n*E\n"})
public final class DefaultEncoderProfilesProvider
implements EncoderProfilesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CameraInfoInternal cameraInfo;
    @NotNull
    private final List<Quality> targetQualities;
    @NotNull
    private final VideoEncoderInfo.Finder videoEncoderInfoFinder;
    @NotNull
    private final Lazy supportedSizes$delegate;
    @NotNull
    private final Map<Integer, EncoderProfilesProxy> encoderProfilesMap;
    public static final int DEFAULT_DURATION_SECONDS = 60;
    public static final int DEFAULT_OUTPUT_FORMAT = 2;
    public static final int DEFAULT_VIDEO_CODEC = 2;
    @NotNull
    public static final String DEFAULT_VIDEO_MIME_TYPE = "video/avc";
    public static final int DEFAULT_VIDEO_FRAME_RATE = 30;
    public static final int DEFAULT_VIDEO_PROFILE = -1;
    public static final int DEFAULT_VIDEO_BIT_DEPTH = 8;
    public static final int DEFAULT_VIDEO_CHROMA_SUBSAMPLING = 0;
    public static final int DEFAULT_VIDEO_HDR_FORMAT = 0;
    public static final int DEFAULT_VIDEO_BITRATE_UHD = 40000000;
    public static final int DEFAULT_VIDEO_BITRATE_FHD = 10000000;
    public static final int DEFAULT_VIDEO_BITRATE_HD = 4000000;
    public static final int DEFAULT_VIDEO_BITRATE_SD = 2000000;
    public static final int DEFAULT_AUDIO_CODEC = 3;
    @NotNull
    public static final String DEFAULT_AUDIO_MIME_TYPE = "audio/mp4a-latm";
    public static final int DEFAULT_AUDIO_BITRATE = 96000;
    public static final int DEFAULT_AUDIO_SAMPLE_RATE = 44100;
    public static final int DEFAULT_AUDIO_CHANNELS = 1;
    public static final int DEFAULT_AUDIO_PROFILE = 2;

    public DefaultEncoderProfilesProvider(@NotNull CameraInfoInternal cameraInfo, @NotNull List<? extends Quality> targetQualities, @NotNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
        Intrinsics.checkNotNullParameter((Object)cameraInfo, (String)"cameraInfo");
        Intrinsics.checkNotNullParameter(targetQualities, (String)"targetQualities");
        Intrinsics.checkNotNullParameter((Object)videoEncoderInfoFinder, (String)"videoEncoderInfoFinder");
        this.cameraInfo = cameraInfo;
        this.targetQualities = targetQualities;
        this.videoEncoderInfoFinder = videoEncoderInfoFinder;
        this.supportedSizes$delegate = LazyKt.lazy(() -> DefaultEncoderProfilesProvider.supportedSizes_delegate$lambda$0(this));
        this.encoderProfilesMap = new LinkedHashMap();
    }

    private final List<Size> getSupportedSizes() {
        Lazy lazy = this.supportedSizes$delegate;
        return (List)lazy.getValue();
    }

    public boolean hasProfile(int quality) {
        return this.getProfileInternal(quality) != null;
    }

    @Nullable
    public EncoderProfilesProxy getAll(int quality) {
        return this.getProfileInternal(quality);
    }

    private final EncoderProfilesProxy getProfileInternal(int quality) {
        EncoderProfilesProxy encoderProfilesProxy;
        if (this.encoderProfilesMap.containsKey(quality)) {
            return this.encoderProfilesMap.get(quality);
        }
        EncoderProfilesProxy it = encoderProfilesProxy = this.generateEncoderProfiles(quality);
        boolean bl = false;
        Integer n = quality;
        this.encoderProfilesMap.put(n, it);
        return encoderProfilesProxy;
    }

    private final EncoderProfilesProxy generateEncoderProfiles(int quality) {
        EncoderProfilesProxy.VideoProfileProxy videoProfileProxy = this.generateVideoProfiles(quality);
        if (videoProfileProxy == null) {
            return null;
        }
        EncoderProfilesProxy.VideoProfileProxy videoProfile = videoProfileProxy;
        return DefaultEncoderProfilesProvider.createDefaultEncoderProfiles$default(this, 0, 0, videoProfile, DefaultEncoderProfilesProvider.createDefaultAudioProfile$default(this, 0, null, 0, 0, 0, 0, 63, null), 3, null);
    }

    private final EncoderProfilesProxy.VideoProfileProxy generateVideoProfiles(int quality) {
        Quality.ConstantQuality constantQuality = this.find(this.targetQualities, quality);
        if (constantQuality == null) {
            return null;
        }
        Quality.ConstantQuality qualityObj = constantQuality;
        for (Size size : qualityObj.getTypicalSizes()) {
            EncoderProfilesProxy.VideoProfileProxy videoProfile;
            if (!this.getSupportedSizes().contains(size) || (videoProfile = this.resolveVideoProfile(size.getWidth(), size.getHeight(), this.getTypicalBitrate(qualityObj))) == null) continue;
            return videoProfile;
        }
        return null;
    }

    private final EncoderProfilesProxy.VideoProfileProxy resolveVideoProfile(int width, int height, int bitrate) {
        EncoderProfilesProxy.VideoProfileProxy videoProfileProxy;
        Integer resolvedBitrate;
        EncoderProfilesProxy.VideoProfileProxy videoProfile = DefaultEncoderProfilesProvider.createDefaultVideoProfile$default(this, 0, null, width, height, bitrate, 0, 0, 0, 0, 0, 995, null);
        VideoEncoderInfo videoEncoderInfo = this.videoEncoderInfoFinder.find(videoProfile.getMediaType());
        if (videoEncoderInfo == null) {
            return null;
        }
        VideoEncoderInfo encoderInfo = videoEncoderInfo;
        if (!encoderInfo.isSizeSupportedAllowSwapping(width, height)) {
            return null;
        }
        Integer n = resolvedBitrate = (Integer)encoderInfo.getSupportedBitrateRange().clamp((Comparable)Integer.valueOf(bitrate));
        int n2 = bitrate;
        if (n == null || n != n2) {
            Intrinsics.checkNotNull((Object)resolvedBitrate);
            videoProfileProxy = DefaultEncoderProfilesProvider.createDefaultVideoProfile$default(this, 0, null, width, height, resolvedBitrate, 0, 0, 0, 0, 0, 995, null);
        } else {
            videoProfileProxy = videoProfile;
        }
        return videoProfileProxy;
    }

    private final EncoderProfilesProxy createDefaultEncoderProfiles(int defaultDurationSeconds, int recommendedFileFormat, EncoderProfilesProxy.VideoProfileProxy videoProfile, EncoderProfilesProxy.AudioProfileProxy audioProfile) {
        EncoderProfilesProxy.ImmutableEncoderProfilesProxy immutableEncoderProfilesProxy = EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create((int)defaultDurationSeconds, (int)recommendedFileFormat, (List)CollectionsKt.listOf((Object)audioProfile), (List)CollectionsKt.listOf((Object)videoProfile));
        Intrinsics.checkNotNullExpressionValue((Object)immutableEncoderProfilesProxy, (String)"create(...)");
        return (EncoderProfilesProxy)immutableEncoderProfilesProxy;
    }

    static /* synthetic */ EncoderProfilesProxy createDefaultEncoderProfiles$default(DefaultEncoderProfilesProvider defaultEncoderProfilesProvider, int n, int n2, EncoderProfilesProxy.VideoProfileProxy videoProfileProxy, EncoderProfilesProxy.AudioProfileProxy audioProfileProxy, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 60;
        }
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        return defaultEncoderProfilesProvider.createDefaultEncoderProfiles(n, n2, videoProfileProxy, audioProfileProxy);
    }

    private final EncoderProfilesProxy.VideoProfileProxy createDefaultVideoProfile(int codec, String mimeType, int width, int height, int bitrate, int frameRate, int profile, int bitDepth, int chromaSubsampling, int hdrFormat) {
        EncoderProfilesProxy.VideoProfileProxy videoProfileProxy = EncoderProfilesProxy.VideoProfileProxy.create((int)codec, (String)mimeType, (int)bitrate, (int)frameRate, (int)width, (int)height, (int)profile, (int)bitDepth, (int)chromaSubsampling, (int)hdrFormat);
        Intrinsics.checkNotNullExpressionValue((Object)videoProfileProxy, (String)"create(...)");
        return videoProfileProxy;
    }

    static /* synthetic */ EncoderProfilesProxy.VideoProfileProxy createDefaultVideoProfile$default(DefaultEncoderProfilesProvider defaultEncoderProfilesProvider, int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object) {
        if ((n10 & 1) != 0) {
            n = 2;
        }
        if ((n10 & 2) != 0) {
            string = DEFAULT_VIDEO_MIME_TYPE;
        }
        if ((n10 & 0x20) != 0) {
            n5 = 30;
        }
        if ((n10 & 0x40) != 0) {
            n6 = -1;
        }
        if ((n10 & 0x80) != 0) {
            n7 = 8;
        }
        if ((n10 & 0x100) != 0) {
            n8 = 0;
        }
        if ((n10 & 0x200) != 0) {
            n9 = 0;
        }
        return defaultEncoderProfilesProvider.createDefaultVideoProfile(n, string, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    private final EncoderProfilesProxy.AudioProfileProxy createDefaultAudioProfile(int codec, String mimeType, int bitRate, int sampleRate, int channels, int profile) {
        EncoderProfilesProxy.AudioProfileProxy audioProfileProxy = EncoderProfilesProxy.AudioProfileProxy.create((int)codec, (String)mimeType, (int)bitRate, (int)sampleRate, (int)channels, (int)profile);
        Intrinsics.checkNotNullExpressionValue((Object)audioProfileProxy, (String)"create(...)");
        return audioProfileProxy;
    }

    static /* synthetic */ EncoderProfilesProxy.AudioProfileProxy createDefaultAudioProfile$default(DefaultEncoderProfilesProvider defaultEncoderProfilesProvider, int n, String string, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = 3;
        }
        if ((n6 & 2) != 0) {
            string = DEFAULT_AUDIO_MIME_TYPE;
        }
        if ((n6 & 4) != 0) {
            n2 = 96000;
        }
        if ((n6 & 8) != 0) {
            n3 = 44100;
        }
        if ((n6 & 0x10) != 0) {
            n4 = 1;
        }
        if ((n6 & 0x20) != 0) {
            n5 = 2;
        }
        return defaultEncoderProfilesProvider.createDefaultAudioProfile(n, string, n2, n3, n4, n5);
    }

    private final int getTypicalBitrate(Quality $this$getTypicalBitrate) {
        int n;
        Quality quality = $this$getTypicalBitrate;
        if (Intrinsics.areEqual((Object)quality, (Object)Quality.UHD)) {
            n = 40000000;
        } else if (Intrinsics.areEqual((Object)quality, (Object)Quality.FHD)) {
            n = 10000000;
        } else if (Intrinsics.areEqual((Object)quality, (Object)Quality.HD)) {
            n = 4000000;
        } else if (Intrinsics.areEqual((Object)quality, (Object)Quality.SD)) {
            n = 2000000;
        } else {
            throw new IllegalArgumentException("Undefined bitrate for quality: " + $this$getTypicalBitrate);
        }
        return n;
    }

    private final Quality.ConstantQuality find(List<? extends Quality> $this$find, int quality) {
        Object v0;
        block1: {
            Iterable iterable = $this$find;
            for (Object t : iterable) {
                Quality it = (Quality)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type androidx.camera.video.Quality.ConstantQuality");
                if (!(((Quality.ConstantQuality)it).getQualityValue(1) == quality)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var3_8 = v0;
        return var3_8 instanceof Quality.ConstantQuality ? (Quality.ConstantQuality)var3_8 : null;
    }

    private static final List supportedSizes_delegate$lambda$0(DefaultEncoderProfilesProvider this$0) {
        return this$0.cameraInfo.getSupportedResolutions(34);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/camera/video/internal/workaround/DefaultEncoderProfilesProvider$Companion;", "", "<init>", "()V", "DEFAULT_DURATION_SECONDS", "", "DEFAULT_OUTPUT_FORMAT", "DEFAULT_VIDEO_CODEC", "DEFAULT_VIDEO_MIME_TYPE", "", "DEFAULT_VIDEO_FRAME_RATE", "DEFAULT_VIDEO_PROFILE", "DEFAULT_VIDEO_BIT_DEPTH", "DEFAULT_VIDEO_CHROMA_SUBSAMPLING", "DEFAULT_VIDEO_HDR_FORMAT", "DEFAULT_VIDEO_BITRATE_UHD", "DEFAULT_VIDEO_BITRATE_FHD", "DEFAULT_VIDEO_BITRATE_HD", "DEFAULT_VIDEO_BITRATE_SD", "DEFAULT_AUDIO_CODEC", "DEFAULT_AUDIO_MIME_TYPE", "DEFAULT_AUDIO_BITRATE", "DEFAULT_AUDIO_SAMPLE_RATE", "DEFAULT_AUDIO_CHANNELS", "DEFAULT_AUDIO_PROFILE", "camera-video_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

