/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Quirks;
import androidx.camera.video.internal.compat.quirk.ExtraSupportedQualityQuirk;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class QualityAddedEncoderProfilesProvider
implements EncoderProfilesProvider {
    private final EncoderProfilesProvider mProvider;
    private @Nullable Map<Integer, EncoderProfilesProxy> mExtraQualityToEncoderProfiles;

    public QualityAddedEncoderProfilesProvider(@NonNull EncoderProfilesProvider provider, @NonNull Quirks quirks, @NonNull CameraInfoInternal cameraInfo, @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
        this.mProvider = provider;
        List extraQuirks = quirks.getAll(ExtraSupportedQualityQuirk.class);
        if (!extraQuirks.isEmpty()) {
            Preconditions.checkState((extraQuirks.size() == 1 ? 1 : 0) != 0);
            Map<Integer, EncoderProfilesProxy> extraEncoderProfiles = ((ExtraSupportedQualityQuirk)extraQuirks.get(0)).getExtraEncoderProfiles(cameraInfo, this.mProvider, videoEncoderInfoFinder);
            if (extraEncoderProfiles != null) {
                this.mExtraQualityToEncoderProfiles = new HashMap<Integer, EncoderProfilesProxy>(extraEncoderProfiles);
            }
        }
    }

    public boolean hasProfile(int quality) {
        return this.getProfilesInternal(quality) != null;
    }

    public @Nullable EncoderProfilesProxy getAll(int quality) {
        return this.getProfilesInternal(quality);
    }

    private @Nullable EncoderProfilesProxy getProfilesInternal(int quality) {
        if (this.mExtraQualityToEncoderProfiles != null && this.mExtraQualityToEncoderProfiles.containsKey(quality)) {
            return this.mExtraQualityToEncoderProfiles.get(quality);
        }
        return this.mProvider.getAll(quality);
    }
}

