/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.internal.compat.quirk.SurfaceProcessingQuirk;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.compat.quirk.VideoQualityQuirk;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class QualityValidatedEncoderProfilesProvider
implements EncoderProfilesProvider {
    private static final Map<Integer, Quality> CAMCORDER_TO_VIDEO_QUALITY_MAP = new HashMap<Integer, Quality>();
    private final @NonNull EncoderProfilesProvider mProvider;
    private final @NonNull CameraInfoInternal mCameraInfo;
    private final @NonNull Quirks mQuirks;

    public QualityValidatedEncoderProfilesProvider(@NonNull EncoderProfilesProvider provider, @NonNull CameraInfoInternal cameraInfo, @NonNull Quirks quirks) {
        this.mProvider = provider;
        this.mCameraInfo = cameraInfo;
        this.mQuirks = quirks;
    }

    public boolean hasProfile(int quality) {
        return this.mProvider.hasProfile(quality) && this.isDeviceValidQuality(quality);
    }

    public @Nullable EncoderProfilesProxy getAll(int quality) {
        if (!this.hasProfile(quality)) {
            return null;
        }
        return this.mProvider.getAll(quality);
    }

    private boolean isDeviceValidQuality(int quality) {
        Quality videoQuality = CAMCORDER_TO_VIDEO_QUALITY_MAP.get(quality);
        if (videoQuality != null) {
            for (VideoQualityQuirk quirk : this.mQuirks.getAll(VideoQualityQuirk.class)) {
                if (quirk == null || !quirk.isProblematicVideoQuality(this.mCameraInfo, videoQuality) || QualityValidatedEncoderProfilesProvider.workaroundBySurfaceProcessing(quirk)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean workaroundBySurfaceProcessing(@NonNull Quirk quirk) {
        return quirk instanceof SurfaceProcessingQuirk && ((SurfaceProcessingQuirk)quirk).workaroundBySurfaceProcessing();
    }

    static {
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(1, Quality.HIGHEST);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(8, Quality.UHD);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(6, Quality.FHD);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(5, Quality.HD);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(4, Quality.SD);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(0, Quality.LOWEST);
    }
}

