/*
 * Decompiled with CFR 0.152.
 */
package androidx.car.app.hardware;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;
import androidx.car.app.hardware.ICarHardwareResult;
import androidx.car.app.serialization.Bundleable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public interface ICarHardwareHost
extends IInterface {
    public static final String DESCRIPTOR = "androidx$car$app$hardware$ICarHardwareHost".replace('$', '.');

    public void getCarHardwareResult(int var1, Bundleable var2, ICarHardwareResult var3) throws RemoteException;

    public void subscribeCarHardwareResult(int var1, Bundleable var2, ICarHardwareResult var3) throws RemoteException;

    public void unsubscribeCarHardwareResult(int var1, Bundleable var2) throws RemoteException;

    public static class _Parcel {
        private static <T> T readTypedObject(Parcel parcel, Parcelable.Creator<T> c) {
            if (parcel.readInt() != 0) {
                return (T)c.createFromParcel(parcel);
            }
            return null;
        }

        private static <T extends Parcelable> void writeTypedObject(Parcel parcel, T value, int parcelableFlags) {
            if (value != null) {
                parcel.writeInt(1);
                value.writeToParcel(parcel, parcelableFlags);
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements ICarHardwareHost {
        static final int TRANSACTION_getCarHardwareResult = 2;
        static final int TRANSACTION_subscribeCarHardwareResult = 3;
        static final int TRANSACTION_unsubscribeCarHardwareResult = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICarHardwareHost asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICarHardwareHost) {
                return (ICarHardwareHost)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 2: {
                    int _arg0 = data.readInt();
                    Bundleable _arg1 = (Bundleable)_Parcel.readTypedObject(data, Bundleable.CREATOR);
                    ICarHardwareResult _arg2 = ICarHardwareResult.Stub.asInterface(data.readStrongBinder());
                    this.getCarHardwareResult(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    Bundleable _arg1 = (Bundleable)_Parcel.readTypedObject(data, Bundleable.CREATOR);
                    ICarHardwareResult _arg2 = ICarHardwareResult.Stub.asInterface(data.readStrongBinder());
                    this.subscribeCarHardwareResult(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    Bundleable _arg1 = (Bundleable)_Parcel.readTypedObject(data, Bundleable.CREATOR);
                    this.unsubscribeCarHardwareResult(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ICarHardwareHost {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCarHardwareResult(int resultType, Bundleable params, ICarHardwareResult callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(resultType);
                    _Parcel.writeTypedObject(_data, (Parcelable)params, 0);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subscribeCarHardwareResult(int resultType, Bundleable params, ICarHardwareResult callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(resultType);
                    _Parcel.writeTypedObject(_data, (Parcelable)params, 0);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsubscribeCarHardwareResult(int resultType, Bundleable params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(resultType);
                    _Parcel.writeTypedObject(_data, (Parcelable)params, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICarHardwareHost {
        @Override
        public void getCarHardwareResult(int resultType, Bundleable params, ICarHardwareResult callback) throws RemoteException {
        }

        @Override
        public void subscribeCarHardwareResult(int resultType, Bundleable params, ICarHardwareResult callback) throws RemoteException {
        }

        @Override
        public void unsubscribeCarHardwareResult(int resultType, Bundleable params) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

