/*
 * Decompiled with CFR 0.152.
 */
package androidx.car.app.hardware;

import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.car.app.CarContext;
import androidx.car.app.HostDispatcher;
import androidx.car.app.annotations.CarProtocol;
import androidx.car.app.annotations.ExperimentalCarApi;
import androidx.car.app.hardware.CarHardwareManager;
import androidx.car.app.hardware.common.CarHardwareHostDispatcher;
import androidx.car.app.hardware.info.CarInfo;
import androidx.car.app.hardware.info.CarSensors;
import androidx.car.app.hardware.info.ProjectedCarInfo;
import androidx.car.app.hardware.info.ProjectedCarSensors;
import org.jspecify.annotations.NonNull;

@CarProtocol
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ProjectedCarHardwareManager
implements CarHardwareManager {
    private final ProjectedCarInfo mVehicleInfo;
    private final ProjectedCarSensors mVehicleSensors;

    public @NonNull CarInfo getCarInfo() {
        return this.mVehicleInfo;
    }

    public @NonNull CarSensors getCarSensors() {
        return this.mVehicleSensors;
    }

    @OptIn(markerClass={ExperimentalCarApi.class})
    public ProjectedCarHardwareManager(@NonNull CarContext context, @NonNull HostDispatcher hostDispatcher) {
        CarHardwareHostDispatcher carHardwareHostDispatcher = new CarHardwareHostDispatcher(hostDispatcher);
        this.mVehicleInfo = new ProjectedCarInfo(carHardwareHostDispatcher);
        this.mVehicleSensors = new ProjectedCarSensors(carHardwareHostDispatcher);
    }
}

