/*
 * Decompiled with CFR 0.152.
 */
package androidx.car.app.hardware.common;

import android.os.RemoteException;
import androidx.annotation.RestrictTo;
import androidx.car.app.HostDispatcher;
import androidx.car.app.hardware.ICarHardwareHost;
import androidx.car.app.hardware.ICarHardwareResult;
import androidx.car.app.serialization.Bundleable;
import androidx.car.app.utils.RemoteUtils;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CarHardwareHostDispatcher {
    private final @NonNull HostDispatcher mHostDispatcher;
    private @Nullable ICarHardwareHost mICarHardwareHost;

    public CarHardwareHostDispatcher(@NonNull HostDispatcher hostDispatcher) {
        this.mHostDispatcher = Objects.requireNonNull(hostDispatcher);
    }

    public void dispatchGetCarHardwareResult(int resultType, @Nullable Bundleable bundle, @NonNull ICarHardwareResult result) {
        Objects.requireNonNull(result);
        RemoteUtils.dispatchCallToHost((String)"getCarHardwareResult", () -> {
            this.getHost().getCarHardwareResult(resultType, bundle, result);
            return null;
        });
    }

    public void dispatchSubscribeCarHardwareResult(int resultType, @Nullable Bundleable bundle, @NonNull ICarHardwareResult callback) {
        Objects.requireNonNull(callback);
        RemoteUtils.dispatchCallToHost((String)"subscribeCarHardwareResult", () -> {
            this.getHost().subscribeCarHardwareResult(resultType, bundle, callback);
            return null;
        });
    }

    public void dispatchUnsubscribeCarHardwareResult(int resultType, @Nullable Bundleable bundle) {
        RemoteUtils.dispatchCallToHost((String)"unsubscribeCarHardwareResult", () -> {
            this.getHost().unsubscribeCarHardwareResult(resultType, bundle);
            return null;
        });
    }

    private @NonNull ICarHardwareHost getHost() throws RemoteException {
        ICarHardwareHost host = this.mICarHardwareHost;
        if (host == null) {
            this.mICarHardwareHost = host = Objects.requireNonNull((ICarHardwareHost)this.mHostDispatcher.dispatchForResult("car", "getHost(CarHardware)", carHost -> ICarHardwareHost.Stub.asInterface(carHost.getHost("hardware"))));
        }
        return host;
    }
}

