/*
 * Decompiled with CFR 0.152.
 */
package androidx.car.app.hardware.common;

import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;
import androidx.car.app.IOnDoneCallback;
import androidx.car.app.hardware.ICarHardwareResult;
import androidx.car.app.hardware.common.CarHardwareHostDispatcher;
import androidx.car.app.hardware.common.OnCarDataAvailableListener;
import androidx.car.app.serialization.Bundleable;
import androidx.car.app.serialization.BundlerException;
import androidx.car.app.utils.RemoteUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CarResultStub<T>
extends ICarHardwareResult.Stub {
    private final CarHardwareHostDispatcher mHostDispatcher;
    private final int mResultType;
    private final @Nullable Bundleable mBundle;
    private final boolean mIsSingleShot;
    private final Map<OnCarDataAvailableListener<T>, Executor> mListeners = new HashMap<OnCarDataAvailableListener<T>, Executor>();
    private final T mUnsupportedValue;

    public CarResultStub(int resultType, @Nullable Bundleable bundle, boolean isSingleShot, @NonNull T unsupportedValue, @NonNull CarHardwareHostDispatcher hostDispatcher) {
        this.mHostDispatcher = Objects.requireNonNull(hostDispatcher);
        this.mResultType = resultType;
        this.mBundle = bundle;
        this.mIsSingleShot = isSingleShot;
        this.mUnsupportedValue = Objects.requireNonNull(unsupportedValue);
    }

    public void addListener(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<T> listener) {
        boolean alreadySubscribedToHost = !this.mListeners.isEmpty();
        this.mListeners.put(Objects.requireNonNull(listener), executor);
        if (alreadySubscribedToHost) {
            return;
        }
        if (this.mIsSingleShot) {
            this.mHostDispatcher.dispatchGetCarHardwareResult(this.mResultType, this.mBundle, this);
        } else {
            this.mHostDispatcher.dispatchSubscribeCarHardwareResult(this.mResultType, this.mBundle, this);
        }
    }

    public boolean removeListener(@NonNull OnCarDataAvailableListener<T> listener) {
        this.mListeners.remove(Objects.requireNonNull(listener));
        if (!this.mListeners.isEmpty()) {
            return false;
        }
        if (!this.mIsSingleShot) {
            this.mHostDispatcher.dispatchUnsubscribeCarHardwareResult(this.mResultType, this.mBundle);
        }
        return true;
    }

    @Override
    public void onCarHardwareResult(int resultType, boolean isSupported, @NonNull Bundleable result, @NonNull IBinder callback) throws RemoteException {
        IOnDoneCallback doneCallback = IOnDoneCallback.Stub.asInterface((IBinder)callback);
        RemoteUtils.dispatchCallFromHost((IOnDoneCallback)doneCallback, (String)"onCarHardwareResult", () -> {
            this.notifyResults(isSupported, result);
            return null;
        });
    }

    private void notifyResults(boolean isSupported, @NonNull Bundleable result) throws BundlerException {
        Object data = isSupported ? this.convertAndRecast(result) : this.mUnsupportedValue;
        for (Map.Entry entry : this.mListeners.entrySet()) {
            entry.getValue().execute(() -> ((OnCarDataAvailableListener)entry.getKey()).onCarDataAvailable(data));
        }
        if (this.mIsSingleShot) {
            this.mListeners.clear();
        }
    }

    private T convertAndRecast(@NonNull Bundleable bundleable) throws BundlerException {
        Object data;
        Object object = bundleable.get();
        try {
            data = object;
        }
        catch (ClassCastException e) {
            throw new BundlerException("Incorrect type unbundled", (Throwable)e);
        }
        return (T)data;
    }
}

