/*
 * Decompiled with CFR 0.152.
 */
package androidx.car.app.hardware.common;

import androidx.annotation.RestrictTo;
import androidx.car.app.hardware.common.CarHardwareHostDispatcher;
import androidx.car.app.hardware.common.CarResultStub;
import androidx.car.app.hardware.common.OnCarDataAvailableListener;
import androidx.car.app.serialization.Bundleable;
import androidx.car.app.serialization.BundlerException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CarResultStubMap<T, U> {
    private final HashMap<U, CarResultStub<T>> mStubMap = new HashMap();
    private final T mUnsupportedValue;
    private final int mResultType;
    private final CarHardwareHostDispatcher mHostDispatcher;

    public CarResultStubMap(int resultType, @NonNull T unsupportedValue, @NonNull CarHardwareHostDispatcher hostDispatcher) {
        this.mResultType = resultType;
        this.mUnsupportedValue = Objects.requireNonNull(unsupportedValue);
        this.mHostDispatcher = Objects.requireNonNull(hostDispatcher);
    }

    public void addListener(@Nullable U params, @NonNull Executor executor, @NonNull OnCarDataAvailableListener<T> listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        CarResultStub<T> stub = this.mStubMap.get(params);
        if (stub != null) {
            stub.addListener(executor, listener);
            return;
        }
        try {
            Bundleable bundle = params == null ? null : Bundleable.create(params);
            stub = new CarResultStub<T>(this.mResultType, bundle, false, this.mUnsupportedValue, this.mHostDispatcher);
            stub.addListener(executor, listener);
            this.mStubMap.put(params, stub);
        }
        catch (BundlerException e) {
            throw new IllegalArgumentException("Invalid params");
        }
    }

    public void removeListener(@NonNull OnCarDataAvailableListener<T> listener) {
        Objects.requireNonNull(listener);
        Iterator<Map.Entry<U, CarResultStub<T>>> iter = this.mStubMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<U, CarResultStub<T>> entry = iter.next();
            if (!entry.getValue().removeListener(listener)) continue;
            iter.remove();
        }
    }
}

