/*
 * Decompiled with CFR 0.152.
 */
package androidx.car.app.hardware.info;

import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.car.app.annotations.ExperimentalCarApi;
import androidx.car.app.hardware.common.CarHardwareHostDispatcher;
import androidx.car.app.hardware.common.CarResultStub;
import androidx.car.app.hardware.common.OnCarDataAvailableListener;
import androidx.car.app.hardware.info.CarInfo;
import androidx.car.app.hardware.info.EnergyLevel;
import androidx.car.app.hardware.info.EnergyProfile;
import androidx.car.app.hardware.info.EvStatus;
import androidx.car.app.hardware.info.ExteriorDimensions;
import androidx.car.app.hardware.info.Mileage;
import androidx.car.app.hardware.info.Model;
import androidx.car.app.hardware.info.Speed;
import androidx.car.app.hardware.info.TollCard;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ProjectedCarInfo
implements CarInfo {
    private final CarResultStub<Model> mModelCarResultStub;
    private final CarResultStub<EnergyProfile> mEnergyProfileCarResultStub;
    private final CarResultStub<TollCard> mTollCarResultStub;
    private final CarResultStub<EnergyLevel> mEnergyLevelCarResultStub;
    private final CarResultStub<Speed> mSpeedCarResultStub;
    private final CarResultStub<Mileage> mMileageCarResultStub;
    private final CarResultStub<EvStatus> mEvStatusCarResultStub;

    @OptIn(markerClass={ExperimentalCarApi.class})
    public ProjectedCarInfo(@NonNull CarHardwareHostDispatcher hostDispatcher) {
        this.mModelCarResultStub = new CarResultStub<Model>(1, null, true, new Model.Builder().build(), hostDispatcher);
        this.mEnergyProfileCarResultStub = new CarResultStub<EnergyProfile>(2, null, true, new EnergyProfile.Builder().build(), hostDispatcher);
        this.mTollCarResultStub = new CarResultStub<TollCard>(3, null, false, new TollCard.Builder().build(), hostDispatcher);
        this.mEnergyLevelCarResultStub = new CarResultStub<EnergyLevel>(4, null, false, new EnergyLevel.Builder().build(), hostDispatcher);
        this.mSpeedCarResultStub = new CarResultStub<Speed>(5, null, false, new Speed.Builder().build(), hostDispatcher);
        this.mMileageCarResultStub = new CarResultStub<Mileage>(6, null, false, new Mileage.Builder().build(), hostDispatcher);
        this.mEvStatusCarResultStub = new CarResultStub<EvStatus>(7, null, false, new EvStatus.Builder().build(), hostDispatcher);
    }

    public void fetchModel(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<Model> listener) {
        this.mModelCarResultStub.addListener(executor, listener);
    }

    public void fetchEnergyProfile(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<EnergyProfile> listener) {
        this.mEnergyProfileCarResultStub.addListener(executor, listener);
    }

    public void fetchExteriorDimensions(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<ExteriorDimensions> listener) {
        executor.execute(() -> listener.onCarDataAvailable((Object)new ExteriorDimensions()));
    }

    public void addTollListener(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<TollCard> listener) {
        this.mTollCarResultStub.addListener(executor, listener);
    }

    public void removeTollListener(@NonNull OnCarDataAvailableListener<TollCard> listener) {
        this.mTollCarResultStub.removeListener(listener);
    }

    public void addEnergyLevelListener(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<EnergyLevel> listener) {
        this.mEnergyLevelCarResultStub.addListener(executor, listener);
    }

    public void removeEnergyLevelListener(@NonNull OnCarDataAvailableListener<EnergyLevel> listener) {
        this.mEnergyLevelCarResultStub.removeListener(listener);
    }

    public void addSpeedListener(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<Speed> listener) {
        this.mSpeedCarResultStub.addListener(executor, listener);
    }

    public void removeSpeedListener(@NonNull OnCarDataAvailableListener<Speed> listener) {
        this.mSpeedCarResultStub.removeListener(listener);
    }

    public void addMileageListener(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<Mileage> listener) {
        this.mMileageCarResultStub.addListener(executor, listener);
    }

    public void removeMileageListener(@NonNull OnCarDataAvailableListener<Mileage> listener) {
        this.mMileageCarResultStub.removeListener(listener);
    }

    @OptIn(markerClass={ExperimentalCarApi.class})
    public void addEvStatusListener(@NonNull Executor executor, @NonNull OnCarDataAvailableListener<EvStatus> listener) {
        this.mEvStatusCarResultStub.addListener(executor, listener);
    }

    @OptIn(markerClass={ExperimentalCarApi.class})
    public void removeEvStatusListener(@NonNull OnCarDataAvailableListener<EvStatus> listener) {
        this.mEvStatusCarResultStub.removeListener(listener);
    }
}

