/*
 * Decompiled with CFR 0.152.
 */
package androidx.car.app.hardware.info;

import androidx.annotation.RestrictTo;
import androidx.car.app.hardware.common.CarHardwareHostDispatcher;
import androidx.car.app.hardware.common.CarResultStubMap;
import androidx.car.app.hardware.common.CarValue;
import androidx.car.app.hardware.common.OnCarDataAvailableListener;
import androidx.car.app.hardware.info.Accelerometer;
import androidx.car.app.hardware.info.CarHardwareLocation;
import androidx.car.app.hardware.info.CarSensors;
import androidx.car.app.hardware.info.Compass;
import androidx.car.app.hardware.info.Gyroscope;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ProjectedCarSensors
implements CarSensors {
    private static final CarValue<List<Float>> UNIMPLEMENTED_FLOAT_LIST = new CarValue(null, 0L, 2);
    private final CarResultStubMap<Accelerometer, Integer> mAccelerometerCarResultStubMap;
    private final CarResultStubMap<Gyroscope, Integer> mGyroscopeCarResultStubMap;
    private final CarResultStubMap<Compass, Integer> mCompassCarResultStubMap;
    private final CarResultStubMap<CarHardwareLocation, Integer> mCarHardwareLocationCarResultStubMap;
    final CarHardwareHostDispatcher mCarHardwareHostDispatcher;

    public ProjectedCarSensors(@NonNull CarHardwareHostDispatcher carHardwareHostDispatcher) {
        this.mCarHardwareHostDispatcher = Objects.requireNonNull(carHardwareHostDispatcher);
        this.mAccelerometerCarResultStubMap = new CarResultStubMap(20, new Accelerometer(UNIMPLEMENTED_FLOAT_LIST), carHardwareHostDispatcher);
        this.mGyroscopeCarResultStubMap = new CarResultStubMap(22, new Gyroscope(UNIMPLEMENTED_FLOAT_LIST), carHardwareHostDispatcher);
        this.mCompassCarResultStubMap = new CarResultStubMap(21, new Compass(UNIMPLEMENTED_FLOAT_LIST), carHardwareHostDispatcher);
        this.mCarHardwareLocationCarResultStubMap = new CarResultStubMap(23, new CarHardwareLocation(new CarValue(null, 0L, 2)), carHardwareHostDispatcher);
    }

    public void addAccelerometerListener(int rate, @NonNull Executor executor, @NonNull OnCarDataAvailableListener<Accelerometer> listener) {
        this.mAccelerometerCarResultStubMap.addListener(rate, Objects.requireNonNull(executor), Objects.requireNonNull(listener));
    }

    public void removeAccelerometerListener(@NonNull OnCarDataAvailableListener<Accelerometer> listener) {
        this.mAccelerometerCarResultStubMap.removeListener(Objects.requireNonNull(listener));
    }

    public void addGyroscopeListener(int rate, @NonNull Executor executor, @NonNull OnCarDataAvailableListener<Gyroscope> listener) {
        this.mGyroscopeCarResultStubMap.addListener(rate, Objects.requireNonNull(executor), Objects.requireNonNull(listener));
    }

    public void removeGyroscopeListener(@NonNull OnCarDataAvailableListener<Gyroscope> listener) {
        this.mGyroscopeCarResultStubMap.removeListener(Objects.requireNonNull(listener));
    }

    public void addCompassListener(int rate, @NonNull Executor executor, @NonNull OnCarDataAvailableListener<Compass> listener) {
        this.mCompassCarResultStubMap.addListener(rate, Objects.requireNonNull(executor), Objects.requireNonNull(listener));
    }

    public void removeCompassListener(@NonNull OnCarDataAvailableListener<Compass> listener) {
        this.mCompassCarResultStubMap.removeListener(Objects.requireNonNull(listener));
    }

    public void addCarHardwareLocationListener(int rate, @NonNull Executor executor, @NonNull OnCarDataAvailableListener<CarHardwareLocation> listener) {
        this.mCarHardwareLocationCarResultStubMap.addListener(rate, Objects.requireNonNull(executor), Objects.requireNonNull(listener));
    }

    public void removeCarHardwareLocationListener(@NonNull OnCarDataAvailableListener<CarHardwareLocation> listener) {
        this.mCarHardwareLocationCarResultStubMap.removeListener(Objects.requireNonNull(listener));
    }
}

