/*
 * Decompiled with CFR 0.152.
 */
package androidx.car.app.media;

import android.util.Log;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.car.app.CarContext;
import androidx.car.app.annotations.CarProtocol;
import androidx.car.app.annotations.KeepFields;
import androidx.car.app.media.CarAudioRecord;
import androidx.car.app.media.OpenMicrophoneResponse;
import java.io.IOException;
import java.io.InputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@CarProtocol
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@KeepFields
public class ProjectedCarAudioRecord
extends CarAudioRecord {
    private @Nullable InputStream mInputStream;

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public ProjectedCarAudioRecord(@NonNull CarContext carContext) {
        super(carContext);
    }

    protected void startRecordingInternal(@NonNull OpenMicrophoneResponse openMicrophoneResponse) {
        this.mInputStream = openMicrophoneResponse.getCarMicrophoneInputStream();
    }

    protected void stopRecordingInternal() {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
                this.mInputStream = null;
            }
        }
        catch (IOException e) {
            Log.e((String)"CarApp", (String)"Exception closing microphone pipe", (Throwable)e);
        }
    }

    protected int readInternal(byte @NonNull [] audioData, int offsetInBytes, int sizeInBytes) {
        InputStream inputStream = this.mInputStream;
        if (inputStream != null) {
            try {
                return inputStream.read(audioData, offsetInBytes, sizeInBytes);
            }
            catch (IOException e) {
                this.stopRecording();
            }
        }
        return -1;
    }
}

