/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lint;

import androidx.compose.foundation.lint.FoundationNames;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSimpleVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Landroidx/compose/foundation/lint/BoxWithConstraintsDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "foundation-lint"})
@SourceDebugExtension(value={"SMAP\nBoxWithConstraintsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxWithConstraintsDetector.kt\nandroidx/compose/foundation/lint/BoxWithConstraintsDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n535#2:177\n520#2,6:178\n808#3,11:184\n*S KotlinDebug\n*F\n+ 1 BoxWithConstraintsDetector.kt\nandroidx/compose/foundation/lint/BoxWithConstraintsDetector\n*L\n56#1:177\n56#1:178,6\n58#1:184,11\n*E\n"})
public final class BoxWithConstraintsDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UnusedConstraintsParameter = Issue.Companion.create("UnusedBoxWithConstraintsScope", "BoxWithConstraints content should use the constraints provided via BoxWithConstraintsScope", "The `content` lambda in BoxWithConstraints has a scope which will include the incoming constraints. If this scope is ignored, then the cost of subcomposition is being wasted and this BoxWithConstraints should be replaced with a Box.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(BoxWithConstraintsDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)FoundationNames.Layout.INSTANCE.getBoxWithConstraints().getShortName());
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (PsiUtilsKt.isInPackageName((PsiMember)method, FoundationNames.Layout.INSTANCE.getPackageName())) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map map = Lint.computeKotlinArgumentMapping((UCallExpression)node, (PsiMethod)method);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map map2 = map;
            boolean $i$f$filter = false;
            void var8_6 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator.next();
                boolean bl = false;
                PsiParameter parameter = (PsiParameter)entry.getValue();
                if (!Intrinsics.areEqual((Object)parameter.getName(), (Object)"content")) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv.keySet();
            boolean $i$f$filterIsInstance = false;
            $this$filterTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Map.Entry element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ULambdaExpression)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ULambdaExpression uLambdaExpression = (ULambdaExpression)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (uLambdaExpression == null) {
                return;
            }
            ULambdaExpression contentArgument = uLambdaExpression;
            Ref.BooleanRef foundValidReference = new Ref.BooleanRef();
            contentArgument.accept((UastVisitor)new AbstractUastVisitor(foundValidReference){
                final /* synthetic */ Ref.BooleanRef $foundValidReference;
                {
                    this.$foundValidReference = $foundValidReference;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                    void this_$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    PsiElement psiElement = node.getSourcePsi();
                    KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
                    if (ktElement == null) {
                        return this.$foundValidReference.element;
                    }
                    KtElement source = ktElement;
                    Ref.BooleanRef booleanRef = this.$foundValidReference;
                    boolean $i$f$analyze = false;
                    Project project = source.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                    boolean $i$f$analyze2 = false;
                    KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(source);
                    this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, source);
                    try {
                        Unit unit;
                        Object lock$iv$iv;
                        Object object = lock$iv$iv = new Object();
                        synchronized (object) {
                            Unit unit2;
                            KaSimpleVariableAccessCall kaSimpleVariableAccessCall;
                            boolean bl = false;
                            KaSession $this$visitSimpleNameReferenceExpression_u24lambda_u241 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            KaCallInfo kaCallInfo = $this$visitSimpleNameReferenceExpression_u24lambda_u241.resolveToCall(source);
                            KaVariableAccessCall kaVariableAccessCall = kaCallInfo != null ? KaCallInfoKt.singleVariableAccessCall((KaCallInfo)kaCallInfo) : null;
                            KaSimpleVariableAccessCall kaSimpleVariableAccessCall2 = kaSimpleVariableAccessCall = kaVariableAccessCall instanceof KaSimpleVariableAccessCall ? (KaSimpleVariableAccessCall)kaVariableAccessCall : null;
                            if (kaSimpleVariableAccessCall != null) {
                                ClassId classId;
                                KaClassSymbol kaClassSymbol;
                                KaType kaType;
                                String receiverFqn;
                                KaSimpleVariableAccessCall variableAccessCall = kaSimpleVariableAccessCall;
                                boolean bl3 = false;
                                KaCallableSymbol kaCallableSymbol = KaCallKt.getSymbol((KaCallableMemberCall)((KaCallableMemberCall)variableAccessCall));
                                KaPropertySymbol propertySymbol = kaCallableSymbol instanceof KaPropertySymbol ? (KaPropertySymbol)kaCallableSymbol : null;
                                KaPropertySymbol kaPropertySymbol = propertySymbol;
                                String containingClassFqn = kaPropertySymbol != null && (kaPropertySymbol = kaPropertySymbol.getCallableId()) != null && (kaPropertySymbol = kaPropertySymbol.getClassId()) != null ? kaPropertySymbol.asFqNameString() : null;
                                String string = receiverFqn = propertySymbol != null && (kaType = KaCallableSymbolKt.getReceiverType((KaCallableSymbol)((KaCallableSymbol)propertySymbol))) != null && (kaClassSymbol = $this$visitSimpleNameReferenceExpression_u24lambda_u241.getExpandedSymbol(kaType)) != null && (classId = kaClassSymbol.getClassId()) != null ? classId.asFqNameString() : null;
                                if (Intrinsics.areEqual((Object)containingClassFqn, (Object)FoundationNames.Layout.INSTANCE.getBoxWithConstraintsScope().getJavaFqn()) || Intrinsics.areEqual(receiverFqn, (Object)FoundationNames.Layout.INSTANCE.getBoxWithConstraintsScope().getJavaFqn())) {
                                    booleanRef.element = true;
                                }
                                unit2 = Unit.INSTANCE;
                            } else {
                                unit2 = null;
                            }
                            unit = unit2;
                        }
                        Unit unit3 = unit;
                    }
                    finally {
                        this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, source);
                    }
                    return this.$foundValidReference.element;
                }

                public boolean visitThisExpression(UThisExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.$foundValidReference.element = true;
                    return this.$foundValidReference.element;
                }

                public boolean visitCallExpression(UCallExpression node) {
                    PsiType resolvedWildcardType;
                    PsiType psiType;
                    Object[] objectArray;
                    PsiJavaCodeReferenceElement psiJavaCodeReferenceElement;
                    PsiClassReferenceType psiClassReferenceType;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    PsiType psiType2 = node.getReceiverType();
                    if (psiType2 == null) {
                        return this.$foundValidReference.element;
                    }
                    PsiType receiverType = psiType2;
                    if (PsiUtilsKt.inheritsFrom(receiverType, FoundationNames.Layout.INSTANCE.getBoxWithConstraintsScope())) {
                        this.$foundValidReference.element = true;
                        return this.$foundValidReference.element;
                    }
                    PsiClassReferenceType psiClassReferenceType2 = psiClassReferenceType = receiverType instanceof PsiClassReferenceType ? (PsiClassReferenceType)receiverType : null;
                    if (psiClassReferenceType == null || (psiJavaCodeReferenceElement = psiClassReferenceType.getReference()) == null || (objectArray = psiJavaCodeReferenceElement.getTypeParameters()) == null || (psiType = (PsiType)ArraysKt.firstOrNull((Object[])objectArray)) == null) {
                        return this.$foundValidReference.element;
                    }
                    PsiType firstChildReceiverType = psiType;
                    PsiWildcardType psiWildcardType = firstChildReceiverType instanceof PsiWildcardType ? (PsiWildcardType)firstChildReceiverType : null;
                    PsiType psiType3 = resolvedWildcardType = psiWildcardType != null ? psiWildcardType.getBound() : null;
                    boolean bl = psiType3 != null ? PsiUtilsKt.inheritsFrom(psiType3, FoundationNames.Layout.INSTANCE.getBoxWithConstraintsScope()) : false;
                    if (bl) {
                        this.$foundValidReference.element = true;
                    }
                    return this.$foundValidReference.element;
                }
            });
            if (!foundValidReference.element) {
                JavaContext.report$default((JavaContext)context, (Issue)UnusedConstraintsParameter, (UElement)((UElement)node), (Location)context.getLocation((UElement)contentArgument), (String)"BoxWithConstraints scope is not used", null, (int)16, null);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/lint/BoxWithConstraintsDetector$Companion;", "", "<init>", "()V", "UnusedConstraintsParameter", "Lcom/android/tools/lint/detector/api/Issue;", "getUnusedConstraintsParameter", "()Lcom/android/tools/lint/detector/api/Issue;", "foundation-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnusedConstraintsParameter() {
            return UnusedConstraintsParameter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

