/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.lint;

import androidx.lint.kotlin.metadata.KmDeclarationContainer;
import androidx.lint.kotlin.metadata.KmFunction;
import androidx.lint.kotlin.metadata.jvm.JvmExtensionsKt;
import androidx.lint.kotlin.metadata.jvm.JvmMetadataUtil;
import androidx.lint.kotlin.metadata.jvm.JvmMethodSignature;
import androidx.lint.kotlin.metadata.jvm.KotlinClassMetadata;
import com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0002H\u0002\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"toKmFunction", "Landroidx/lint/kotlin/metadata/KmFunction;", "Lcom/intellij/psi/PsiMethod;", "getKmDeclarationContainer", "Landroidx/lint/kotlin/metadata/KmDeclarationContainer;", "Lcom/intellij/psi/PsiClass;", "toMetadataAnnotation", "Lkotlin/Metadata;", "Lcom/intellij/psi/PsiAnnotation;", "findKmFunctionForPsiMethod", "method", "KotlinMetadataFqn", "", "common"})
@SourceDebugExtension(value={"SMAP\nKotlinMetadataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataUtils.kt\nandroidx/compose/lint/KotlinMetadataUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,131:1\n1187#2,2:132\n1261#2,4:134\n1557#2:138\n1628#2,3:139\n1557#2:144\n1628#2,3:145\n37#3,2:142\n37#3,2:148\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataUtils.kt\nandroidx/compose/lint/KotlinMetadataUtilsKt\n*L\n79#1:132,2\n79#1:134,4\n88#1:138\n88#1:139,3\n91#1:144\n91#1:145,3\n88#1:142,2\n91#1:148,2\n*E\n"})
public final class KotlinMetadataUtilsKt {
    @NotNull
    private static final String KotlinMetadataFqn = "kotlin.Metadata";

    @Nullable
    public static final KmFunction toKmFunction(@NotNull PsiMethod $this$toKmFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$toKmFunction, (String)"<this>");
        PsiClass psiClass = $this$toKmFunction.getContainingClass();
        Intrinsics.checkNotNull((Object)psiClass);
        KmDeclarationContainer kmDeclarationContainer = KotlinMetadataUtilsKt.getKmDeclarationContainer(psiClass);
        return kmDeclarationContainer != null ? KotlinMetadataUtilsKt.findKmFunctionForPsiMethod(kmDeclarationContainer, $this$toKmFunction) : null;
    }

    private static final KmDeclarationContainer getKmDeclarationContainer(PsiClass $this$getKmDeclarationContainer) {
        KmDeclarationContainer kmDeclarationContainer;
        KotlinClassMetadata metadata;
        KotlinClassMetadata kotlinClassMetadata;
        Object object;
        block16: {
            PsiAnnotation[] psiAnnotationArray = $this$getKmDeclarationContainer.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
            for (Object object2 : (Object[])psiAnnotationArray) {
                PsiAnnotation it = (PsiAnnotation)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)KotlinMetadataFqn)) continue;
                object = object2;
                break block16;
            }
            object = null;
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)object;
        if (psiAnnotation == null) {
            return null;
        }
        PsiAnnotation classKotlinMetadataPsiAnnotation = psiAnnotation;
        try {
            kotlinClassMetadata = KotlinClassMetadata.Companion.readStrict(KotlinMetadataUtilsKt.toMetadataAnnotation(classKotlinMetadataPsiAnnotation));
        }
        catch (Exception e) {
            return null;
        }
        kotlinClassMetadata = metadata = kotlinClassMetadata;
        if (kotlinClassMetadata instanceof KotlinClassMetadata.Class) {
            kmDeclarationContainer = ((KotlinClassMetadata.Class)metadata).getKmClass();
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.FileFacade) {
            kmDeclarationContainer = ((KotlinClassMetadata.FileFacade)metadata).getKmPackage();
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.SyntheticClass) {
            kmDeclarationContainer = null;
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.MultiFileClassFacade) {
            kmDeclarationContainer = null;
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
            kmDeclarationContainer = ((KotlinClassMetadata.MultiFileClassPart)metadata).getKmPackage();
        } else if (kotlinClassMetadata instanceof KotlinClassMetadata.Unknown) {
            kmDeclarationContainer = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return kmDeclarationContainer;
    }

    /*
     * WARNING - void declaration
     */
    private static final Metadata toMetadataAnnotation(PsiAnnotation $this$toMetadataAnnotation) {
        void $this$associateTo$iv$iv;
        List list = $this$toMetadataAnnotation.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            JvmAnnotationAttribute it = (JvmAnnotationAttribute)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getAttributeName(), (Object)it.getAttributeValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map attributes = destination$iv$iv;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = (JvmAnnotationAttributeValue)attributes.get("k");
        Integer kind2 = jvmAnnotationAttributeValue != null ? Integer.valueOf(KotlinMetadataUtilsKt.toMetadataAnnotation$parseInt(jvmAnnotationAttributeValue)) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue2 = (JvmAnnotationAttributeValue)attributes.get("mv");
        int[] metadataVersion = (int[])(jvmAnnotationAttributeValue2 != null ? KotlinMetadataUtilsKt.toMetadataAnnotation$parseIntArray(jvmAnnotationAttributeValue2) : null);
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue3 = (JvmAnnotationAttributeValue)attributes.get("d1");
        String[] data1 = jvmAnnotationAttributeValue3 != null ? KotlinMetadataUtilsKt.toMetadataAnnotation$parseStringArray(jvmAnnotationAttributeValue3) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue4 = (JvmAnnotationAttributeValue)attributes.get("d2");
        String[] data2 = jvmAnnotationAttributeValue4 != null ? KotlinMetadataUtilsKt.toMetadataAnnotation$parseStringArray(jvmAnnotationAttributeValue4) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue5 = (JvmAnnotationAttributeValue)attributes.get("xs");
        String extraString = jvmAnnotationAttributeValue5 != null ? KotlinMetadataUtilsKt.toMetadataAnnotation$parseString(jvmAnnotationAttributeValue5) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue6 = (JvmAnnotationAttributeValue)attributes.get("pn");
        String packageName = jvmAnnotationAttributeValue6 != null ? KotlinMetadataUtilsKt.toMetadataAnnotation$parseString(jvmAnnotationAttributeValue6) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue7 = (JvmAnnotationAttributeValue)attributes.get("xi");
        Integer extraInt = jvmAnnotationAttributeValue7 != null ? Integer.valueOf(KotlinMetadataUtilsKt.toMetadataAnnotation$parseInt(jvmAnnotationAttributeValue7)) : null;
        return JvmMetadataUtil.Metadata(kind2, metadataVersion, data1, data2, extraString, packageName, extraInt);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final KmFunction findKmFunctionForPsiMethod(KmDeclarationContainer $this$findKmFunctionForPsiMethod, PsiMethod method) {
        Object t;
        Object v1;
        boolean bl;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String expectedName = StringsKt.substringBefore$default((String)string, (String)"-", null, (int)2, null);
        String expectedSignature = ClassUtil.getAsmMethodSignature((PsiMethod)method);
        String unitReturnTypeSuffix = "Lkotlin/Unit;";
        Intrinsics.checkNotNull((Object)expectedSignature);
        String expectedSignatureConvertedFromUnitToVoid = StringsKt.endsWith$default((String)expectedSignature, (String)unitReturnTypeSuffix, (boolean)false, (int)2, null) ? StringsKt.substringBeforeLast$default((String)expectedSignature, (String)unitReturnTypeSuffix, null, (int)2, null) + "V" : expectedSignature;
        Iterable iterable = $this$findKmFunctionForPsiMethod.getFunctions();
        Iterator iterator = iterable.iterator();
        do {
            block5: {
                block6: {
                    if (!iterator.hasNext()) {
                        v1 = null;
                        return v1;
                    }
                    t = iterator.next();
                    KmFunction it = (KmFunction)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)expectedName)) break block5;
                    JvmMethodSignature jvmMethodSignature = JvmExtensionsKt.getSignature(it);
                    if (Intrinsics.areEqual((Object)(jvmMethodSignature != null ? jvmMethodSignature.getDescriptor() : null), (Object)expectedSignature)) break block6;
                    JvmMethodSignature jvmMethodSignature2 = JvmExtensionsKt.getSignature(it);
                    if (!Intrinsics.areEqual((Object)(jvmMethodSignature2 != null ? jvmMethodSignature2.getDescriptor() : null), (Object)expectedSignatureConvertedFromUnitToVoid)) break block5;
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (!bl);
        v1 = t;
        return v1;
    }

    private static final String toMetadataAnnotation$parseString(JvmAnnotationAttributeValue $this$toMetadataAnnotation_u24parseString) {
        Intrinsics.checkNotNull((Object)$this$toMetadataAnnotation_u24parseString, (String)"null cannot be cast to non-null type com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue");
        Object object = ((JvmAnnotationConstantValue)$this$toMetadataAnnotation_u24parseString).getConstantValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    private static final int toMetadataAnnotation$parseInt(JvmAnnotationAttributeValue $this$toMetadataAnnotation_u24parseInt) {
        Intrinsics.checkNotNull((Object)$this$toMetadataAnnotation_u24parseInt, (String)"null cannot be cast to non-null type com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue");
        Object object = ((JvmAnnotationConstantValue)$this$toMetadataAnnotation_u24parseInt).getConstantValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final String[] toMetadataAnnotation$parseStringArray(JvmAnnotationAttributeValue $this$toMetadataAnnotation_u24parseStringArray) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)$this$toMetadataAnnotation_u24parseStringArray, (String)"null cannot be cast to non-null type com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue");
        List list = ((JvmAnnotationArrayValue)$this$toMetadataAnnotation_u24parseStringArray).getValues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmAnnotationAttributeValue jvmAnnotationAttributeValue = (JvmAnnotationAttributeValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(KotlinMetadataUtilsKt.toMetadataAnnotation$parseString((JvmAnnotationAttributeValue)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final int[] toMetadataAnnotation$parseIntArray(JvmAnnotationAttributeValue $this$toMetadataAnnotation_u24parseIntArray) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)$this$toMetadataAnnotation_u24parseIntArray, (String)"null cannot be cast to non-null type com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue");
        List list = ((JvmAnnotationArrayValue)$this$toMetadataAnnotation_u24parseIntArray).getValues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmAnnotationAttributeValue jvmAnnotationAttributeValue = (JvmAnnotationAttributeValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(KotlinMetadataUtilsKt.toMetadataAnnotation$parseInt((JvmAnnotationAttributeValue)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return ArraysKt.toIntArray((Integer[])thisCollection$iv.toArray(new Integer[0]));
    }
}

