/*
 * Decompiled with CFR 0.152.
 */
package androidx.photopicker.testing;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.widget.photopicker.EmbeddedPhotoPickerClient;
import android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo;
import android.widget.photopicker.EmbeddedPhotoPickerProvider;
import android.widget.photopicker.EmbeddedPhotoPickerSession;
import androidx.annotation.RequiresExtension;
import androidx.photopicker.testing.TestEmbeddedPhotoPickerSession;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 J\u001c\u0010!\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u001c\u0010%\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Landroidx/photopicker/testing/TestEmbeddedPhotoPickerProvider;", "Landroid/widget/photopicker/EmbeddedPhotoPickerProvider;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "sessionClientMap", "", "Landroid/widget/photopicker/EmbeddedPhotoPickerSession;", "Landroid/widget/photopicker/EmbeddedPhotoPickerClient;", "getSessionClientMap$photopicker_testing_release", "()Ljava/util/Map;", "sessions", "", "getSessions", "()Ljava/util/Set;", "openSession", "", "hostToken", "Landroid/os/IBinder;", "displayId", "", "width", "height", "featureInfo", "Landroid/widget/photopicker/EmbeddedPhotoPickerFeatureInfo;", "clientExecutor", "Ljava/util/concurrent/Executor;", "callback", "notifySessionError", "session", "throwable", "", "notifySelectedUris", "uris", "", "Landroid/net/Uri;", "notifyDeselectedUris", "notifySelectionComplete", "Companion", "photopicker-testing_release"})
@RequiresExtension(extension=34, version=15)
@SourceDebugExtension(value={"SMAP\nTestEmbeddedPhotoPickerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestEmbeddedPhotoPickerProvider.kt\nandroidx/photopicker/testing/TestEmbeddedPhotoPickerProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class TestEmbeddedPhotoPickerProvider
implements EmbeddedPhotoPickerProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Map<EmbeddedPhotoPickerSession, EmbeddedPhotoPickerClient> sessionClientMap;

    public TestEmbeddedPhotoPickerProvider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.sessionClientMap = new LinkedHashMap();
    }

    @NotNull
    public final Map<EmbeddedPhotoPickerSession, EmbeddedPhotoPickerClient> getSessionClientMap$photopicker_testing_release() {
        return this.sessionClientMap;
    }

    @NotNull
    public final Set<EmbeddedPhotoPickerSession> getSessions() {
        return this.sessionClientMap.keySet();
    }

    public void openSession(@NotNull IBinder hostToken, int displayId, int width, int height, @NotNull EmbeddedPhotoPickerFeatureInfo featureInfo, @NotNull Executor clientExecutor, @NotNull EmbeddedPhotoPickerClient callback) {
        Intrinsics.checkNotNullParameter((Object)hostToken, (String)"hostToken");
        Intrinsics.checkNotNullParameter((Object)featureInfo, (String)"featureInfo");
        Intrinsics.checkNotNullParameter((Object)clientExecutor, (String)"clientExecutor");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        clientExecutor.execute(() -> TestEmbeddedPhotoPickerProvider.openSession$lambda$4(this, hostToken, displayId, width, height, featureInfo, callback));
    }

    public final void notifySessionError(@NotNull EmbeddedPhotoPickerSession session, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        boolean bl = this.sessionClientMap.containsKey(session);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "This session is unknown to this TestEmbeddedPhotoPickerProvider.";
            throw new AssertionError((Object)string);
        }
        EmbeddedPhotoPickerClient client = (EmbeddedPhotoPickerClient)MapsKt.getValue(this.sessionClientMap, (Object)session);
        client.onSessionError(throwable);
    }

    public final void notifySelectedUris(@NotNull EmbeddedPhotoPickerSession session, @NotNull List<? extends Uri> uris) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(uris, (String)"uris");
        boolean bl = this.sessionClientMap.containsKey(session);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "This session is unknown to this TestEmbeddedPhotoPickerProvider.";
            throw new AssertionError((Object)string);
        }
        EmbeddedPhotoPickerClient client = (EmbeddedPhotoPickerClient)MapsKt.getValue(this.sessionClientMap, (Object)session);
        client.onUriPermissionGranted(uris);
    }

    public final void notifyDeselectedUris(@NotNull EmbeddedPhotoPickerSession session, @NotNull List<? extends Uri> uris) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(uris, (String)"uris");
        boolean bl = this.sessionClientMap.containsKey(session);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "This session is unknown to this TestEmbeddedPhotoPickerProvider.";
            throw new AssertionError((Object)string);
        }
        EmbeddedPhotoPickerClient client = (EmbeddedPhotoPickerClient)MapsKt.getValue(this.sessionClientMap, (Object)session);
        client.onUriPermissionRevoked(uris);
    }

    public final void notifySelectionComplete(@NotNull EmbeddedPhotoPickerSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        boolean bl = this.sessionClientMap.containsKey(session);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "This session is unknown to this TestEmbeddedPhotoPickerProvider.";
            throw new AssertionError((Object)string);
        }
        EmbeddedPhotoPickerClient client = (EmbeddedPhotoPickerClient)MapsKt.getValue(this.sessionClientMap, (Object)session);
        client.onSelectionComplete();
    }

    private static final void openSession$lambda$4(TestEmbeddedPhotoPickerProvider this$0, IBinder $hostToken, int $displayId, int $width, int $height, EmbeddedPhotoPickerFeatureInfo $featureInfo, EmbeddedPhotoPickerClient $callback) {
        TestEmbeddedPhotoPickerSession session = new TestEmbeddedPhotoPickerSession(this$0.context, $hostToken, $displayId, $width, $height, $featureInfo, $callback);
        this$0.sessionClientMap.put(session, $callback);
        $callback.onSessionOpened((EmbeddedPhotoPickerSession)session);
    }

    @JvmStatic
    @NotNull
    public static final TestEmbeddedPhotoPickerProvider get() {
        return Companion.get();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Landroidx/photopicker/testing/TestEmbeddedPhotoPickerProvider$Companion;", "", "<init>", "()V", "get", "Landroidx/photopicker/testing/TestEmbeddedPhotoPickerProvider;", "photopicker-testing_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TestEmbeddedPhotoPickerProvider get() {
            Context context = InstrumentationRegistry.getInstrumentation().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            return new TestEmbeddedPhotoPickerProvider(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

