/*
 * Decompiled with CFR 0.152.
 */
package androidx.photopicker.testing;

import android.content.Context;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.IBinder;
import android.os.Looper;
import android.view.Display;
import android.view.SurfaceControlViewHost;
import android.view.View;
import android.widget.photopicker.EmbeddedPhotoPickerClient;
import android.widget.photopicker.EmbeddedPhotoPickerFeatureInfo;
import android.widget.photopicker.EmbeddedPhotoPickerSession;
import androidx.annotation.MainThread;
import androidx.annotation.RequiresExtension;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0016\u0010!\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J \u0010%\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroidx/photopicker/testing/TestEmbeddedPhotoPickerSession;", "Landroid/widget/photopicker/EmbeddedPhotoPickerSession;", "context", "Landroid/content/Context;", "hostToken", "Landroid/os/IBinder;", "displayId", "", "width", "height", "featureInfo", "Landroid/widget/photopicker/EmbeddedPhotoPickerFeatureInfo;", "clientCallback", "Landroid/widget/photopicker/EmbeddedPhotoPickerClient;", "<init>", "(Landroid/content/Context;Landroid/os/IBinder;IIILandroid/widget/photopicker/EmbeddedPhotoPickerFeatureInfo;Landroid/widget/photopicker/EmbeddedPhotoPickerClient;)V", "_view", "Landroid/view/View;", "_host", "Landroid/view/SurfaceControlViewHost;", "getSurfacePackage", "Landroid/view/SurfaceControlViewHost$SurfacePackage;", "close", "", "notifyConfigurationChanged", "configuration", "Landroid/content/res/Configuration;", "notifyPhotoPickerExpanded", "isExpanded", "", "notifyResized", "notifyVisibilityChanged", "isVisible", "requestRevokeUriPermission", "uris", "", "Landroid/net/Uri;", "createSurfaceControlViewHost", "photopicker-testing_release"})
@RequiresExtension(extension=34, version=15)
@SourceDebugExtension(value={"SMAP\nTestEmbeddedPhotoPickerSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestEmbeddedPhotoPickerSession.kt\nandroidx/photopicker/testing/TestEmbeddedPhotoPickerSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class TestEmbeddedPhotoPickerSession
implements EmbeddedPhotoPickerSession {
    @NotNull
    private final IBinder hostToken;
    private final int displayId;
    private final int width;
    private final int height;
    @NotNull
    private final EmbeddedPhotoPickerFeatureInfo featureInfo;
    @NotNull
    private final EmbeddedPhotoPickerClient clientCallback;
    @NotNull
    private final View _view;
    @NotNull
    private final SurfaceControlViewHost _host;

    public TestEmbeddedPhotoPickerSession(@NotNull Context context, @NotNull IBinder hostToken, int displayId, int width, int height, @NotNull EmbeddedPhotoPickerFeatureInfo featureInfo, @NotNull EmbeddedPhotoPickerClient clientCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)hostToken, (String)"hostToken");
        Intrinsics.checkNotNullParameter((Object)featureInfo, (String)"featureInfo");
        Intrinsics.checkNotNullParameter((Object)clientCallback, (String)"clientCallback");
        this.hostToken = hostToken;
        this.displayId = displayId;
        this.width = width;
        this.height = height;
        this.featureInfo = featureInfo;
        this.clientCallback = clientCallback;
        this._view = new View(context);
        this._host = this.createSurfaceControlViewHost(context, this.displayId, this.hostToken);
        this._host.setView(this._view, this.width, this.height);
    }

    @NotNull
    public SurfaceControlViewHost.SurfacePackage getSurfacePackage() {
        SurfaceControlViewHost.SurfacePackage surfacePackage = this._host.getSurfacePackage();
        if (surfacePackage == null) {
            boolean bl = false;
            String string = "SurfacePackage was null.";
            throw new IllegalStateException(string.toString());
        }
        return surfacePackage;
    }

    @MainThread
    public void close() {
        if (!Intrinsics.areEqual((Object)Looper.getMainLooper().getThread(), (Object)Thread.currentThread())) {
            throw new IllegalStateException("Cannot invoke close on a background thread");
        }
        this._host.release();
    }

    public void notifyConfigurationChanged(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this._view.dispatchConfigurationChanged(configuration);
    }

    public void notifyPhotoPickerExpanded(boolean isExpanded) {
    }

    public void notifyResized(int width, int height) {
        this._host.relayout(width, height);
    }

    public void notifyVisibilityChanged(boolean isVisible) {
    }

    public void requestRevokeUriPermission(@NotNull List<? extends Uri> uris) {
        Intrinsics.checkNotNullParameter(uris, (String)"uris");
    }

    private final SurfaceControlViewHost createSurfaceControlViewHost(Context context, int displayId, IBinder hostToken) {
        Object object = context.getSystemService(DisplayManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSystemService(...)");
        DisplayManager displayManager = (DisplayManager)object;
        Display display = displayManager.getDisplay(displayId);
        if (display == null) {
            boolean bl = false;
            String string = "The displayId provided to openSession did not result in a valid display.";
            throw new IllegalStateException(string.toString());
        }
        Display display2 = display;
        return new SurfaceControlViewHost(context, display2, hostToken);
    }
}

